# -*- coding: utf-8 -*-

from travel.rasp.admin.importinfo.models.two_stage_import import TSIThreadStationFlag
from travel.rasp.admin.scripts.schedule.utils.supplier_station import SupplierStation


PARAM_TO_PYTHON = {
    'none': None,
    'true': True,
    'false': False,
}


class Filter(object):
    def __init__(self, params):
        self.params = params

    def apply(self, package, tsi_thread, tsi_stations):
        if not self.params:
            return

        self.set_default_flags(package, tsi_thread, tsi_stations)

    def set_default_flags(self, package, tsi_thread, tsi_stations):
        for tsi_station in tsi_stations:
            tsi_station_key = SupplierStation.KEY_DELIMITER.join(map(unicode, [tsi_station.title, tsi_station.code]))

            TSIThreadStationFlag.objects.get_or_create(
                package=package,
                path_key=tsi_thread.path_key,
                station_key=tsi_station_key,
                defaults={
                    'is_fuzzy': PARAM_TO_PYTHON[self.params['is_fuzzy']],
                    'is_searchable_from': PARAM_TO_PYTHON[self.params['is_searchable_from']],
                    'is_searchable_to': PARAM_TO_PYTHON[self.params['is_searchable_to']],
                    'in_station_schedule': PARAM_TO_PYTHON[self.params['in_station_schedule']],
                }
            )
