# -*- coding: utf-8 -*-


class Filter(object):
    def __init__(self, params):
        self.params = params

        self.comment = None

        if self.params:
            self.comment = self.params['thread_comment_string'] or u''

    def apply(self, thread):
        if self.params:
            self._set_comment(thread)

    def _set_comment(self, thread):
        thread.comment = self.comment
