# -*- coding: utf-8 -*-


class Filter(object):
    def __init__(self, params):
        self.params = params

        self.timezone = 'none'

        if self.params:
            self.timezone = self.params['timezone']

    def apply(self, cysix_rtstation):
        if not self.params or self.timezone == 'none':
            return None

        return cysix_rtstation.get_timezone(self.timezone)
