# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import cysix.fields


class Migration(migrations.Migration):

    dependencies = [
        ('importinfo', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Filter',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0444\u0438\u043b\u044c\u0442\u0440\u0430')),
                ('code', models.CharField(unique=True, max_length=255, verbose_name='\u041a\u043e\u0434 \u0444\u0438\u043b\u044c\u0442\u0440\u0430')),
                ('default_parameters', cysix.fields.PackageFilterParametersField(default=None, null=True, verbose_name='\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0444\u0438\u043b\u044c\u0442\u0440\u0430 \u0438 \u0438\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e', blank=True)),
                ('default_use', models.BooleanField(default=True, verbose_name='\u0412\u043a\u043b\u044e\u0447\u0435\u043d \u043b\u0438 \u0434\u0430\u043d\u043d\u044b\u0439 \u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e-\u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e')),
                ('order', models.IntegerField(default=1000, verbose_name='\u041f\u043e\u0440\u044f\u0434\u043e\u043a \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0438 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0444\u0438\u043b\u044c\u0442\u0440\u0430')),
            ],
            options={
                'verbose_name': '\u0444\u0438\u043b\u044c\u0442\u0440 \u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e',
                'verbose_name_plural': '\u0444\u0438\u043b\u044c\u0442\u0440\u044b \u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e',
            },
        ),
        migrations.CreateModel(
            name='PackageFilter',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('use', models.BooleanField(default=False, help_text='\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u0440\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0435', verbose_name='\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c')),
                ('parameters', cysix.fields.PackageFilterParametersField(default=None, null=True, verbose_name='\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0444\u0438\u043b\u044c\u0442\u0440\u0430 \u0438 \u0438\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u043f\u0430\u043a\u0435\u0442\u0430', blank=True)),
                ('filter', models.ForeignKey(verbose_name='\u0424\u0438\u043b\u044c\u0442\u0440', to='cysix.Filter')),
                ('package', models.ForeignKey(verbose_name='\u041f\u0430\u043a\u0435\u0442', to='importinfo.TwoStageImportPackage')),
            ],
            options={
                'verbose_name': '\u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u0430\u043a\u0435\u0442\u0430',
                'verbose_name_plural': '\u0444\u0438\u043b\u044c\u0442\u0440\u044b \u043f\u0430\u043a\u0435\u0442\u043e\u0432',
            },
        ),
        migrations.AddField(
            model_name='filter',
            name='packages',
            field=models.ManyToManyField(to='importinfo.TwoStageImportPackage', through='cysix.PackageFilter'),
        ),
        migrations.AlterUniqueTogether(
            name='packagefilter',
            unique_together=set([('filter', 'package')]),
        ),
    ]
