# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations

FILTER_CODE = 'check_path_geometry'


def add_geometry_filter(apps, schema_editor):

    filter_ = apps.get_model('cysix', 'Filter')()
    filter_.title = 'Скрывать нитки с неправильной геометрией'
    filter_.code = FILTER_CODE
    filter_.default_parameters = """[
                        {
                            "code": "update_data",
                            "type": "bool",
                            "value": false,
                            "title": "Обновить значения предыдущего расчета. Установить только при изменении алгоритма"
                        }
                    ]"""
    filter_.default_use = False
    filter_.order = 4500
    filter_.save()

    packages = apps.get_model('importinfo', 'TwoStageImportPackage').objects.all()

    for package in packages:
        package_filter = apps.get_model('cysix.PackageFilter')()
        package_filter.filter = filter_
        package_filter.package = package
        package_filter.use = False
        package_filter.parameters = filter_.default_parameters

        package_filter.save()


def delete_geometry_filter(apps, schema_editor):
    apps.get_model('cysix', 'Filter').objects.get(code=FILTER_CODE).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('cysix', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(add_geometry_filter, reverse_code=delete_geometry_filter),
    ]
