# coding: utf-8

from __future__ import unicode_literals

from django.db import migrations


FILTER_CODE = 'correct_arrival_time_by_map'


def add_geometry_filter(apps, schema_editor):
    filter_ = apps.get_model('cysix', 'Filter')()
    filter_.title = 'Коррекция времен прибытия по карточному маршрутизатору'
    filter_.code = FILTER_CODE
    filter_.default_parameters = """[
                        {
                            "code": "min_correction_time",
                            "type": "int",
                            "value": 5,
                            "title": "Не делать корректировку если суммарное изменение времени меньше мин."
                        },
                        {
                            "code": "verbose_log",
                            "type": "bool",
                            "value": true,
                            "title": "Выводить подробную информацию в лог"
                        },
                        {
                            "code": "correct_not_approved_path",
                            "type": "bool",
                            "value": false,
                            "title": "Корректировать неподтвержденные маршруты"
                        }
                    ]"""
    filter_.default_use = False
    filter_.order = 6500
    filter_.save()

    packages = apps.get_model('importinfo', 'TwoStageImportPackage').objects.all()

    for package in packages:
        package_filter = apps.get_model('cysix.PackageFilter')()
        package_filter.filter = filter_
        package_filter.package = package
        package_filter.use = False
        package_filter.parameters = filter_.default_parameters

        package_filter.save()


def delete_geometry_filter(apps, schema_editor):
    apps.get_model('cysix', 'Filter').objects.get(code=FILTER_CODE).delete()


class Migration(migrations.Migration):
    dependencies = [
        ('cysix', '0002_add_geometry_check_filter'),
    ]

    operations = [
        migrations.RunPython(add_geometry_filter, reverse_code=delete_geometry_filter),
    ]
