# -*- coding: utf-8 -*-

from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.admin.importinfo.models.two_stage_import import TwoStageImportPackage, CysixGroupFilter
from cysix.fields import PackageFilterParametersField


class Filter(models.Model):
    app_label = 'cysix'
    title = models.CharField(_(u"Название фильтра"), max_length=255)
    code = models.CharField(_(u"Код фильтра"), max_length=255, unique=True)
    default_parameters = PackageFilterParametersField(_(u"Параметры фильтра и их значения по умолчанию"),
                                                      default=None, null=True, blank=True)
    default_use = models.BooleanField(_(u"Включен ли данный фильтр по-умолчанию"), default=True)
    order = models.IntegerField(_(u"Порядок применения и отображения фильтра"), default=1000)
    packages = models.ManyToManyField(TwoStageImportPackage, through='PackageFilter')

    class Meta:
        verbose_name = _(u'фильтр и значения по умолчанию')
        verbose_name_plural = _(u'фильтры и значения по умолчанию')

    def __unicode__(self):
        return self.title


class PackageFilter(models.Model):
    filter = models.ForeignKey(Filter, verbose_name=_(u"Фильтр"))
    package = models.ForeignKey(TwoStageImportPackage, verbose_name=_(u"Пакет"))
    use = models.BooleanField(_(u"Использовать"), default=False, help_text=_(u"Использовать фильтр при импорте"))
    parameters = PackageFilterParametersField(_(u"Параметры фильтра и их значения для пакета"),
                                              default=None, null=True, blank=True)

    class Meta:
        unique_together = ('filter', 'package',)
        verbose_name = _(u'фильтр пакета')
        verbose_name_plural = _(u'фильтры пакетов')

    def __unicode__(self):
        return self.package.title + u': ' + self.filter.title


class PackageGroupFilter(models.Model):
    cysix_group_filter = models.ForeignKey(CysixGroupFilter, verbose_name=_(u'Фильтр по группам общего формата'))
    filter = models.ForeignKey(Filter, verbose_name=_(u"Фильтр"))
    use = models.BooleanField(_(u"Использовать"), default=False, help_text=_(u"Использовать фильтр при импорте"))
    parameters = PackageFilterParametersField(_(u"Параметры фильтра и их значения для пакета"),
                                              default=None, null=True, blank=True)

    class Meta:
        unique_together = ('filter', 'cysix_group_filter')
        verbose_name = _(u'фильтр общего XML-формата группы пакета')
        verbose_name_plural = _(u'фильтры общего XML-формата групп пакетов')

    def __unicode__(self):
        return self.cysix_group_filter.title + u': ' + self.filter.title

