PY2_LIBRARY()

OWNER(
    g:rasp-back
)

PEERDIR(
    contrib/python/httpretty
    contrib/python/pytest

    library/python/resource

    travel/library/python/resource
    travel/rasp/admin
    travel/rasp/admin/tester
)

RESOURCE_FILES( PREFIX travel/rasp/admin/cysix/tests/
    data/cysix_test_template/cysix.xml
    data/test_arrival_and_departure_correction/cysix.xml
    data/test_arrival_and_departure_correction/cysix_by_distance_correction.xml
    data/test_arrival_and_departure_correction/cysix_by_time_correction.xml
    data/test_arrival_and_departure_correction/cysix_day_shift.xml
    data/test_arrival_and_departure_correction/cysix_nonstop_technical.xml
    data/test_arrival_and_departure_correction/cysix_several_equal_times.xml
    data/test_arrival_and_departure_correction/cysix_skip_stop_with_only_add_day.xml
    data/test_arrival_and_departure_correction/cysix_trust_day_shift.xml
    data/test_arrival_and_departure_correction/cysix_zero_bug.xml
    data/test_cysix_converted_rts/arrival_rts.xml
    data/test_exclude_from_path_majority_stations/cysix.xml
    data/test_factory/test.txt
    data/test_import/test_days_masks.xml
    data/test_import/test_times.xml
    data/test_import/test_times_2.xml
    data/test_import/test_times_3.xml
    data/test_import/test_times_error.xml
    data/test_import/test_times_error_2.xml
    data/test_import/threads.xml
    data/test_import_comment/comment_in_group.xml
    data/test_import_comment/comment_in_interval_schedule.xml
    data/test_import_comment/comment_in_schedule.xml
    data/test_import_comment/comment_in_thread.xml
    data/test_import_comment/do_not_glue_schedules_with_different_comments.xml
    data/test_import_density/density_in_group.xml
    data/test_import_density/density_in_not_interval_thread.xml
    data/test_import_density/density_in_schedule.xml
    data/test_import_density/density_in_thread.xml
    data/test_import_density/do_not_glue_schedules_with_different_densities.xml
    data/test_import_fares/empty_price_in_fare.xml
    data/test_import_fares/fare_days_delimeter.xml
    data/test_import_fares/invalid_fare.xml
    data/test_import_fares/invalid_fare_code_in_thread.xml
    data/test_import_fares/invalid_fare_link.xml
    data/test_import_fares/threads.xml
    data/test_import_fares/threads_fare_links.xml
    data/test_import_with_not_mapped_station/not_mapped_in_the_middle.xml
    data/test_not_mapped_stations/first_not_mapped_station.xml
    data/test_not_mapped_stations/last_not_mapped_station.xml
    data/test_not_mapped_stations/middle_not_mapped_station.xml
    data/test_public_schema/test_carrier/invalid_no_code.xml
    data/test_public_schema/test_carrier/invalid_no_title.xml
    data/test_public_schema/test_carrier/valid1.xml
    data/test_public_schema/test_carrier/valid_phone.xml
    data/test_public_schema/test_carrier/valid_with_real_carrier.xml
    data/test_public_schema/test_channel/invalid1.xml
    data/test_public_schema/test_channel/invalid2.xml
    data/test_public_schema/test_channel/invalid_not_xml.xml
    data/test_public_schema/test_channel/invalid_were_valid1.xml
    data/test_public_schema/test_channel/valid_arm_version.xml
    data/test_public_schema/test_channel/valid_subtype_empty.xml
    data/test_public_schema/test_channel/valid_subtype_gazel.xml
    data/test_public_schema/test_comment/valid_comments.xml
    data/test_public_schema/test_consistency/invalid_no_such_iata_code_DDD.xml
    data/test_public_schema/test_consistency/valid_with_iata_code.xml
    data/test_public_schema/test_consistency/valid_with_iata_code_and_geometry.xml
    data/test_public_schema/test_density/valid_density.xml
    data/test_public_schema/test_fare/invalid_no_code.xml
    data/test_public_schema/test_fare/invalid_nonexistent_currency.xml
    data/test_public_schema/test_fare/invalid_not_our_currency.xml
    data/test_public_schema/test_fare/invalid_price_no_currency.xml
    data/test_public_schema/test_fare/invalid_price_no_price.xml
    data/test_public_schema/test_fare/invalid_price_value.xml
    data/test_public_schema/test_fare/valid1.xml
    data/test_public_schema/test_fare/valid2.xml
    data/test_public_schema/test_fare/valid_many_currencies.xml
    data/test_public_schema/test_group/invalid1.xml
    data/test_public_schema/test_group/invalid2.xml
    data/test_public_schema/test_group/invalid_were_valid1.xml
    data/test_public_schema/test_group/invalid_were_valid2.xml
    data/test_public_schema/test_group/valid_arm_version.xml
    data/test_public_schema/test_real/valid-cysix-2013-06-27.xml
    data/test_public_schema/test_real/valid-lzz-2013-07-01.xml
    data/test_public_schema/test_station/invalid1.xml
    data/test_public_schema/test_station/invalid_no_code.xml
    data/test_public_schema/test_station/invalid_stoppoint_distance.xml
    data/test_public_schema/test_station/invalid_stoppoint_distance_2.xml
    data/test_public_schema/test_station/valid1.xml
    data/test_public_schema/test_station/valid_geocode_title.xml
    data/test_public_schema/test_station/valid_lat_lon.xml
    data/test_public_schema/test_station/valid_no_station.xml
    data/test_public_schema/test_station/valid_no_title.xml
    data/test_public_schema/test_station/valid_stoppoint_distance.xml
    data/test_public_schema/test_thread/invalid_flag.xml
    data/test_public_schema/test_thread/invalid_is_fuzzy.xml
    data/test_public_schema/test_thread/invalid_no_shedules.xml
    data/test_public_schema/test_thread/invalid_sales.xml
    data/test_public_schema/test_thread/invalid_stoppoint_no_station_code.xml
    data/test_public_schema/test_thread/invalid_stoppoints_no_stoppoints.xml
    data/test_public_schema/test_thread/invalid_subtype_big_length.xml
    data/test_public_schema/test_thread/valid1.xml
    data/test_public_schema/test_thread/valid_empty_subtype.xml
    data/test_public_schema/test_thread/valid_flag.xml
    data/test_public_schema/test_thread/valid_ignore_base_stations.xml
    data/test_public_schema/test_thread/valid_is_fuzzy.xml
    data/test_public_schema/test_thread/valid_minimum.xml
    data/test_public_schema/test_thread/valid_no_number.xml
    data/test_public_schema/test_thread/valid_no_stoppoint_in_stoppoints.xml
    data/test_public_schema/test_thread/valid_no_stoppoints.xml
    data/test_public_schema/test_thread/valid_no_t_type.xml
    data/test_public_schema/test_thread/valid_sales.xml
    data/test_public_schema/test_thread/valid_shedule_no_shedule.xml
    data/test_public_schema/test_thread/valid_shedule_no_timezone.xml
    data/test_public_schema/test_thread/valid_stoppoint_only_one_stoppoint.xml
    data/test_public_schema/test_thread/valid_subtype.xml
    data/test_public_schema/test_thread_fare_link/invalid_attribute.xml
    data/test_public_schema/test_thread_fare_link/invalid_no_code.xml
    data/test_public_schema/test_thread_fare_link/valid_complex.xml
    data/test_public_schema/test_thread_fare_link/valid_simple.xml
    data/test_public_schema/test_timezone/invalid_0.xml
    data/test_public_schema/test_timezone/valid_0.xml
    data/test_public_schema/test_vehicle/invalid_no_code.xml
    data/test_public_schema/test_vehicle/invalid_no_title.xml
    data/test_public_schema/test_vehicle/valid1.xml
    data/test_sales_flag/cysix.xml
    data/test_stations/stations.xml
    data/test_triangle/carriers.xls
    data/test_triangle/test_split_errors.xls
    data/test_triangle/test_triangle_import.xls
    data/test_triangle/test_triangle_import_add_day.xls
    data/test_triangle/test_triangle_import_skip_times.xls
    data/test_triangle/test_triangle_import_with_filters.xls
    data/test_use_thread_in_station_code/cysix.xml
    data/test_vehicles/cysix.xml

    test_fare_is_min_price/cysix.xml
    test_show_in_alldays_pages/cysix.xml
    test_stoppoint_flags/cysix.xml
    test_stoppoint_is_combined/cysix.xml
    test_stoppoint_is_fuzzy/cysix.xml
    test_timezone_end_station/cysix.xml
    test_timezone_override/cysix.xml

)

RESOURCE_FILES( PREFIX travel/rasp/admin/cysix/tests/
    fixtures/currency.yaml
    fixtures/points.yaml
    fixtures/settlement.yaml
    fixtures/stations.yaml
    fixtures/supplier.yaml
    fixtures/template_package_base.yaml
    fixtures/test_arrival_and_departure_correction.yaml
    fixtures/test_use_thread_in_station_code.yaml
    fixtures/test_vehicles.yaml
    fixtures/triangle.yaml
)

SET(_SRCS
    cysix_test_template.py
    fares/test_import_thread_when_fares_are_invalid.py
    filters/cysix_xml_thread/__init__.py
    filters/cysix_xml_thread/test_skip_staiton_without_times.py
    mask_parser/test_every_n_day_mask.py
    test_allow_mapping_by_code_and_use_thread_code.py
    test_allow_station_mapping_by_code.py
    test_arrival_and_departure_correction.py
    test_carriers_companies.py
    test_check_path_geometry.py
    test_correct_arrival_time_by_map.py
    test_exclude_from_path_majority_stations.py
    test_factory.py
    test_fare_is_min_price/__init__.py
    test_import.py
    test_import_comment.py
    test_import_density.py
    test_import_fares.py
    test_import_local_timezone.py
    test_import_tariff_flag.py
    test_import_uid.py
    test_import_with_day_shift.py
    test_import_with_iata_stations.py
    test_import_with_not_mapped_station.py
    test_is_transit.py
    test_local_time_for_time_shifts.py
    test_max_forward_days.py
    test_middle_base_import.py
    test_not_mapped_stations.py
    test_public_schema.py
    test_replace_local_time_by_shift.py
    test_sales_flag.py
    test_set_default_flags.py
    test_show_in_alldays_pages/__init__.py
    test_station_is_base.py
    test_station_is_base_ignore_base_stations.py
    test_station_is_base_setting.py
    test_station_is_trusted.py
    test_stations.py
    test_stoppoint_flags/__init__.py
    test_stoppoint_is_combined/test_stoppoints.py
    test_stoppoint_is_fuzzy/__init__.py
    test_subtype_import.py
    test_text_schedule_and_extrapolation.py
    test_thread_period_end.py
    test_thread_setting.py
    test_timezone_end_station/__init__.py
    test_timezone_override/__init__.py
    test_transition_warning.py
    test_transports_validation.py
    test_triangle/test_country.py
    test_triangle/test_station_mapping.py
    test_triangle/test_subtype.py
    test_triangle/test_triangle_import.py
    test_tsi_station_geotitle.py
    test_ttype_sea_river.py
    test_use_thread_in_station_code.py
    test_vehicles.py
    two_stage_import/test_route_importer.py
)

PY_SRCS( 
    NAMESPACE cysix.tests
    conftest.py
    utils.py
    fares/__init__.py
    filters/__init__.py
    mask_parser/__init__.py
    two_stage_import/__init__.py
)

IF(DEBUG_WITH_PYCHARM)
    PY_SRCS(
        NAMESPACE cysix.tests
        # Duplicate all test files here for debug via PyCharm (RASPFRONT-7607)
        ${_SRCS}
    )
ENDIF()

TEST_SRCS(
    ${_SRCS}
)

END()

