# -*- coding: utf-8 -*-

import logging
import os.path

from django.conf import settings
from django.utils.translation import gettext_noop as N_

from cysix.two_stage_import.factory import CysixTSIFactory
from common.utils.caching import cache_method_result_with_exception
from travel.rasp.admin.scripts.schedule.utils.file_providers import PackageFileProvider


log = logging.getLogger(__name__)


class CysixTSIConverterFactory(CysixTSIFactory):
    def get_package_file_provider(self):
        raw_file_provider = self.get_raw_package_file_provider()

        if not raw_file_provider:
            log.info(N_(u'Не поддерживается конвертация с приложенного файла'))

            return None

        log.info(N_(u'Конвертируем из приложенного файла'))

        return self.get_converter_file_provider(raw_file_provider)

    def get_download_file_provider(self):
        raw_file_provider = self.get_raw_download_file_provider()

        if not raw_file_provider:
            log.info(N_(u'Не поддерживается скачиваение для конвертации'))

            return None

        log.info(N_(u'Конвертируем из скачанного файла'))

        return self.get_converter_file_provider(raw_file_provider)

    def get_raw_package_file_provider(self):
        raise NotImplementedError()

    def get_raw_download_file_provider(self):
        raise NotImplementedError()

    def get_converter_file_provider(self, raw_file_provider):
        raise NotImplementedError()


class CysixTSIConverterFileProvider(PackageFileProvider):
    def __init__(self, package, raw_file_provider):
        self.package = package
        self.raw_file_provider = raw_file_provider

        super(CysixTSIConverterFileProvider, self).__init__(package)

    @cache_method_result_with_exception
    def get_cysix_file(self):
        filepath = self.get_package_filepath("cysix.xml")

        if os.path.exists(filepath) and not settings.DEBUG:
            log.info(N_(u'Данные уже были сконвертированы в общий xml %s'), filepath)

            return filepath

        log.info(N_(u'Конвертируем в общий xml %s'), filepath)

        self.convert_data(filepath)

        log.info(N_(u'Данные сконвертированы в общий xml %s'), filepath)

        return filepath

    def convert_data(self, filepath):
        raise NotImplementedError()
