# coding: utf-8

from lxml import etree

from common.cysix.builder import ChannelBlock, GroupBlock, ThreadBlock, StoppointBlock, ScheduleBlock
from common.models.transport import TransportType
from travel.rasp.library.python.common23.date import environment


def create_cysix_from_threads(threads, filepath, group_code='all', group_title='all'):
    channel_block = ChannelBlock('bus', station_code_system='yandex', carrier_code_system='local',
                                 vehicle_code_system='local', timezone='local')

    group_block = GroupBlock(channel_block, group_title, group_code)
    _build_threads(group_block, threads)
    channel_block.add_group_block(group_block)

    with open(filepath, 'w') as f:
        f.write(etree.tostring(channel_block.get_element(), xml_declaration=True, encoding='utf-8', pretty_print=True))


def _build_threads(group_block, threads):
    today = environment.today()
    for thread in threads:
        cysix_t_type = thread.t_type.code if thread.t_type_id != TransportType.WATER_ID else thread.t_subtype.code
        thread_block = ThreadBlock(group_block, title=thread.title, number=thread.number, timezone=thread.time_zone,
                                   t_type=cysix_t_type)
        days = ';'.join(d.strftime('%Y-%m-%d') for d in thread.get_mask(today=today).dates())
        schedule = ScheduleBlock(thread_block, days=days, times=thread.tz_start_time.strftime('%H:%M'))
        thread_block.add_schedule_block(schedule)
        for rts in list(thread.path):
            rts.station.code = str(rts.station.id)
            rts.station.code_system = 'yandex'
            stoppoint_block = StoppointBlock(
                thread_block,
                rts.station,
                arrival_shift=rts.tz_arrival,
                departure_shift=rts.tz_departure,
                timezone=rts.time_zone
            )
            thread_block.add_stoppoint_block(stoppoint_block)

        group_block.add_thread_block(thread_block)
