#!/bin/bash

set -e

if [ ! -d /opt/nodejs/0.10/ ]; then
    echo 'Не поставлена нужная нода' >> /dev/stderr
    exit 1
fi

export NODE_PATH=/opt/nodejs/0.10/lib:$NODE_PATH
export PATH=/opt/nodejs/0.10/bin:$PATH


old_make() {
    STANDALONE_PAGES="coach-schema validate"

    make -C static/markup YENV=production

    find static/markup -depth -name ".svn" -exec rm -rf \{\} \;

    for page in $STANDALONE_PAGES; do
        ycssjs --once=yes --minimize=yes --freeze=yes \
            static/markup/pages-desktop/$page/$page.css \
            static/markup/pages-desktop/$page/$page.ie*.css;
    done;
}

geoadmins_make() {
    (
        cd static/rasp/geoadmins;
        rm -rf node_modules/
        npm install
        # При сборке у нас fakeroot
        node_modules/.bin/bower --allow-root install
        node_modules/grunt-cli/bin/grunt -v dist

        for dir in common.blocks desktop.blocks desktop.bundles; do
            [ -d $dir ] && find $dir -regextype posix-extended \( \
                -regex ".*\.(gif|png|jpe?g|sfw|ico|svg|woff|ttf)" -o \
                -regex ".*/_[^/]*\.css" -o \
                -regex ".*/_[^/]*\.pub\.js" -o \
                -regex ".*/_[^/.]*\.js" \
                \) -exec install -D \{\} static/\{\} \;
        done
    );
}

old_make

find ./static/rasp/ \
    \( -name '*.css' -or -name '*.js' \) \
    -not \( -path './static/rasp/geoadmins*' -or -path './static/rasp/' \) \
    \
    | xargs -P 3 ycssjs --minimize=no

geoadmins_make
