#!/bin/bash

./bin/docker-entrypoint.sh


function copy_push_client_config(){
    if [ "$YENV_TYPE" = "production" ] || [ "$YENV_TYPE" = "testing" ];
    then
        local copy_from="/docker/statbox-push-client/$1/$YENV_TYPE/files.yaml"
        echo $copy_from
        cp $copy_from /etc/yandex/statbox-push-client/
    fi
}


if [ -z "$DEPLOY_NODE_DC" ];
then
    cp /docker/nginx/conf.d/* /etc/nginx/conf.d/
fi


if [ "$RASP_SERVICE_INSTANCE" = "true" ];
then
    cp /docker/cron/service/* /etc/cron.d/
    cp /docker/logrotate/service/* /etc/logrotate.d/
    cp /docker/nginx/service/* /etc/nginx/sites-enabled/
    copy_push_client_config "service"
elif [ "$RASP_WORK_INSTANCE" = "true" ];
then
    cp /docker/cron/admin/* /etc/cron.d/
    cp /docker/logrotate/admin/* /etc/logrotate.d/
    cp /docker/nginx/admin/* /etc/nginx/sites-enabled/
    copy_push_client_config "admin"
else
    echo "env RASP_SERVICE_INSTANCE or RASP_WORK_INSTANCE must be set!"
    exit 1
fi

exec "$@"
