import os
import sys
import signal
import time
import traceback
import codecs


preload_app = True
proc_name = 'rasp-admins'

limit_request_line = 8190
timeout = graceful_timeout = 5 * 3600


def recache_callback(server_pid):
    def callback():
        os.kill(server_pid, signal.SIGHUP)

    return callback


def precache(server):
    while True:
        try:
            server.log.info("Precaching...")

            server.app.wsgi().precache(recache_callback(os.getpid()))
        except:
            server.log.info("Unhandled exception in precache:\n" + traceback.format_exc())
            server.log.info("Retrying in 30 seconds")

            time.sleep(30)

            continue

        break

    server.log.info("Done")


def post_fork(server, worker):
    from django.conf import settings

    stdout_path = os.path.join(settings.LOG_PATH, 'gunicorn_stdout.log')
    stderr_path = os.path.join(settings.LOG_PATH, 'gunicorn_stderr.log')

    sys.stdout = codecs.open(stdout_path, 'a', encoding='utf-8', errors='replace')
    sys.stderr = codecs.open(stderr_path, 'a', encoding='utf-8', errors='replace')


try:
    from gunicorn_conf_local import *  # noqa
    print '\nLoad local config'

except ImportError:
    pass

sys.stdout.flush()
sys.stderr.flush()
