# -*- coding: utf-8 -*-


from collections import OrderedDict


class ActionsStore(object):
    def __init__(self):
        self.model_actions = OrderedDict()

    @classmethod
    def build_action_key_from_model(cls, model, action_type):
        return (model._meta.app_label, model._meta.model_name, action_type)

    def model_action(self, model, action_type, help_text=None):
        action_key = self.build_action_key_from_model(model, action_type)

        def register_model_action(func):
            self.model_actions[action_key] = {
                'model': model,
                'action_type': action_type,
                'func': func,
                'help_text': help_text
            }

            return func

        return register_model_action

    def run_model_action(self, model, action_type, db_change_el):
        action_key = self.build_action_key_from_model(model, action_type)
        action = self.model_actions[action_key]
        action['func'](db_change_el)
