# coding: utf-8

import logging

from django.apps import apps

from travel.rasp.admin.admin.admin_tasks import run_task, TaskLog
from travel.rasp.library.python.common23.date import environment
from travel.rasp.admin.importinfo.afdbchanges import actions
from travel.rasp.admin.importinfo.models.af import AFDBChangesFile
from travel.rasp.admin.lib.maintenance.flags import flags
from travel.rasp.admin.lib.xmlutils import lxml_humanize


log = logging.getLogger(__name__)


def run_apply_af_db_changes_as_task(af_db_changes):
    task_log = TaskLog.from_object_action(af_db_changes, 'import')
    with task_log.capture_log():
        if flags['maintenance']:
            log.error(u'Идет работа с базой данных нельзя запускать импорт изменений')
            return

    run_task(task_log, apply_af_db_changes, args=(af_db_changes.id,))


def apply_af_db_changes(db_changes_id):
    af_db_changes = AFDBChangesFile.objects.get(pk=db_changes_id)
    log.info(u'Импортируем изменения объектов %s %s', af_db_changes.id, af_db_changes.changes_file.name)

    run_actions(af_db_changes.get_xml_tree())

    af_db_changes.imported_at = environment.now()
    log.info(u'Изменения объектов %s %s импортированы', af_db_changes.id, af_db_changes.changes_file.name)


def run_actions(tree):
    for db_change_el in tree.findall('./dbchange'):
        el_data = lxml_humanize(db_change_el).strip()
        try:
            log.info(u'Пробуем применить изменение %s', el_data)
            model = apps.get_model(*db_change_el.get('model').split('.'))
            action_type = db_change_el.get('type')
            actions.store.run_model_action(model, action_type, db_change_el)
        except Exception:
            log.exception(u'Ошибка применения изменения %s', el_data)
