# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from travel.rasp.admin.importinfo.models.trusted_station import TrustedStation
from travel.rasp.admin.importinfo.models.two_stage_import import TSISetting, TwoStageImportPackage, CysixGroupFilter
from common.tester.factories import ModelFactory, factories


class TSISettingFactory(ModelFactory):
    Model = TSISetting


create_tsi_settings = factories[TSISettingFactory] = TSISettingFactory()


class TwoStageImportPackageFactory(ModelFactory):
    Model = TwoStageImportPackage

    default_kwargs = {
        'supplier': {},
        'new_trusted': False
    }

    def create_object(self, kwargs):
        tsi_settings = kwargs.pop('tsi_settings', {})
        package = super(TwoStageImportPackageFactory, self).create_object(kwargs)
        create_tsi_settings(package=package, **tsi_settings)

        return package

create_tsi_package = factories[TwoStageImportPackage] = TwoStageImportPackageFactory()


class TrustedStationFactory(ModelFactory):
    Model = TrustedStation

create_trusted_station = factories[TrustedStation] = TrustedStationFactory()


class CysixGroupFilterFactory(ModelFactory):
    Model = CysixGroupFilter

    default_kwargs = {
        'tsi_import_available': True,
        'tsi_middle_available': True,
        'use_thread_in_station_code': False
    }

create_cysix_group_filter = factories[CysixGroupFilter] = CysixGroupFilterFactory()


