# -*- coding: utf-8 -*-

import logging
from optparse import make_option

from django.core.management.base import BaseCommand, CommandError

from travel.rasp.admin.importinfo.models.two_stage_import import TwoStageImportPackage
from travel.rasp.admin.importinfo.two_stage_import.admin import run_tsi
from travel.rasp.admin.lib.logs import create_run_log, print_log_to_stdout, capture_stdstreams


log = logging.getLogger(__name__)


# Наследуем, чтобы обработались все аргументы
class Command(BaseCommand):
    help = u'Запускает двухсутпенчатый импорт'
    args = 'package_id action'

    option_list = BaseCommand.option_list + (
        make_option('-c', '--capture-stdstreams', action='store_true', dest='capture_stdstreams', default=False,
                    help=u'Перенаправить stdout и stderr в лог'),
    )

    def handle(self, package_id=None, action=None, **kwargs):
        file = create_run_log('special.management_runs.' + __name__)

        if kwargs.get('capture_stdstreams'):
            capture_stdstreams(file)

        elif int(kwargs.get('verbosity', 0)) > 0:
            print_log_to_stdout()

        if not package_id:
            raise CommandError("Need exactly one TSI Package Id")

        package = TwoStageImportPackage.objects.get(pk=int(package_id))

        if not action:
            raise CommandError("Please specify action")

        run_tsi(action, package)
