# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import travel.rasp.admin.importinfo.models.validators
import django.db.models.deletion
import common.utils.fields
import travel.rasp.admin.importinfo.models.model_extenders
import travel.rasp.admin.lib.fields
import travel.rasp.admin.www.models.geo


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0001_initial'),
        ('contenttypes', '0002_remove_content_type_name'),
        ('currency', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AFMaskText',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(max_length=10, verbose_name='\u041a\u043e\u0434')),
                ('description', models.TextField(default='', verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u0447\u0438\u043a\u043e\u0432', blank=True)),
                ('next_code', models.CharField(default='', max_length=10, verbose_name='\u041a\u043e\u0434 \u0434\u043b\u044f +1 \u0434\u043d\u044f', blank=True)),
                ('prev_code', models.CharField(default='', max_length=10, verbose_name='\u041a\u043e\u0434 \u0434\u043b\u044f -1 \u0434\u043d\u044f', blank=True)),
                ('long_text_ru', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u0414\u043b\u0438\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442, \u0434\u043b\u044f \u0435\u0434\u0438\u043d\u0438\u0447\u043d\u044b\u0445 \u0441\u043b\u0443\u0447\u0430\u0435\u0432 (ru)', blank=True)),
                ('long_text_en', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u0414\u043b\u0438\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442, \u0434\u043b\u044f \u0435\u0434\u0438\u043d\u0438\u0447\u043d\u044b\u0445 \u0441\u043b\u0443\u0447\u0430\u0435\u0432 (en)', blank=True)),
                ('long_text_tr', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u0414\u043b\u0438\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442, \u0434\u043b\u044f \u0435\u0434\u0438\u043d\u0438\u0447\u043d\u044b\u0445 \u0441\u043b\u0443\u0447\u0430\u0435\u0432 (tr)', blank=True)),
                ('long_text_uk', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u0414\u043b\u0438\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442, \u0434\u043b\u044f \u0435\u0434\u0438\u043d\u0438\u0447\u043d\u044b\u0445 \u0441\u043b\u0443\u0447\u0430\u0435\u0432 (uk)', blank=True)),
                ('short_text_ru', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u041a\u043e\u0440\u043e\u0442\u043a\u0438\u0439 \u0442\u0435\u043a\u0441\u0442, \u0434\u043b\u044f \u043a\u043e\u043c\u0431\u0438\u043d\u0430\u0446\u0438\u0439 (ru)', blank=True)),
                ('short_text_en', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u041a\u043e\u0440\u043e\u0442\u043a\u0438\u0439 \u0442\u0435\u043a\u0441\u0442, \u0434\u043b\u044f \u043a\u043e\u043c\u0431\u0438\u043d\u0430\u0446\u0438\u0439 (en)', blank=True)),
                ('short_text_tr', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u041a\u043e\u0440\u043e\u0442\u043a\u0438\u0439 \u0442\u0435\u043a\u0441\u0442, \u0434\u043b\u044f \u043a\u043e\u043c\u0431\u0438\u043d\u0430\u0446\u0438\u0439 (tr)', blank=True)),
                ('short_text_uk', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u041a\u043e\u0440\u043e\u0442\u043a\u0438\u0439 \u0442\u0435\u043a\u0441\u0442, \u0434\u043b\u044f \u043a\u043e\u043c\u0431\u0438\u043d\u0430\u0446\u0438\u0439 (uk)', blank=True)),
            ],
            options={
                'ordering': ('id',),
                'verbose_name': '\u0410.\u0424.: \u041f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u0430\u0441\u043a\u0438 \u0432 \u0442\u0435\u043a\u0441\u0442',
                'verbose_name_plural': '\u0410.\u0424.: \u041f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043c\u0430\u0441\u043a\u0438 \u0432 \u0442\u0435\u043a\u0441\u0442',
            },
        ),
        migrations.CreateModel(
            name='AFScheduleFile',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('schedule_file_name', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430', blank=True)),
                ('schedule_file', common.utils.fields.TextFileField(help_text='\u041f\u0440\u0438\u043d\u0438\u043c\u0430\u044e\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0435 \u0444\u0430\u0439\u043b\u044b \u0432 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0435 cp1251', verbose_name='\u0424\u0430\u0439\u043b \u0441 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f\u043c\u0438')),
                ('added', models.DateTimeField(auto_now_add=True, verbose_name='\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d')),
                ('imported', models.DateTimeField(default=None, help_text='\u0415\u0441\u043b\u0438 \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0430, \u0437\u043d\u0430\u0447\u0438\u0442 \u0444\u0430\u0439\u043b \u0435\u0449\u0435 \u043d\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043b\u0441\u044f', null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0444\u0430\u0439\u043b\u0430', blank=True)),
                ('region', models.ForeignKey(verbose_name='\u041e\u0431\u043b\u0430\u0441\u0442\u044c', to='www.Region', help_text='\u041a\u0443\u0434\u0430 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u044e\u0442\u0441\u044f \u043d\u043e\u0432\u044b\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u0435\u0441\u043b\u0438 \u0435\u0441\u0442\u044c')),
            ],
            options={
                'ordering': ('-added',),
                'verbose_name': '\u042d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u043a\u0438: \u0424\u0430\u0439\u043b \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f',
                'verbose_name_plural': '\u042d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u043a\u0438: \u0424\u0430\u0439\u043b\u044b \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f',
            },
        ),
        migrations.CreateModel(
            name='AFSubwayFile',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('subway_file_name', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0430\u0440\u0445\u0438\u0432\u0430', blank=True)),
                ('stations_file_name', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 \u0441\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u044f\u043c\u0438', blank=True)),
                ('stations_file', common.utils.fields.TextFileField(help_text='\u041f\u0440\u0438\u043d\u0438\u043c\u0430\u044e\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0435 CSV-\u0444\u0430\u0439\u043b\u044b \u0432 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0435 cp1251', verbose_name='\u0424\u0430\u0439\u043b \u0441\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u044f\u043c\u0438')),
                ('passages_file_name', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 \u0441 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430\u043c\u0438', blank=True)),
                ('passages_file', common.utils.fields.TextFileField(help_text='\u041f\u0440\u0438\u043d\u0438\u043c\u0430\u044e\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0435 CSV-\u0444\u0430\u0439\u043b\u044b \u0432 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0435 cp1251', verbose_name='\u0424\u0430\u0439\u043b \u0441 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430\u043c\u0438')),
                ('threads_file_name', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 \u0441 \u043d\u0438\u0442\u043a\u0430\u043c\u0438', blank=True)),
                ('threads_file', common.utils.fields.TextFileField(help_text='\u041f\u0440\u0438\u043d\u0438\u043c\u0430\u044e\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0435 XML-\u0444\u0430\u0439\u043b\u044b \u0432 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0435 cp1251 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 \u0410\u0424', verbose_name='\u0424\u0430\u0439\u043b \u0441 \u043d\u0438\u0442\u043a\u0430\u043c\u0438')),
                ('add_mode', models.BooleanField(default=False, help_text='\u0415\u0441\u043b\u0438 \u0440\u0435\u0436\u0438\u043c \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u043a\u043b\u044e\u0447\u0435\u043d, \u0442\u043e \u043f\u0435\u0440\u0435\u0434 \u0438\u043c\u043f\u043e\u0440\u0442\u043e\u043c \u043d\u0435 \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u043e\u0447\u0438\u0441\u0442\u043a\u0438 \u0441\u0442\u0430\u0440\u043e\u0433\u043e \u043c\u0435\u0442\u0440\u043e', verbose_name='\u0420\u0435\u0436\u0438\u043c \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f')),
                ('load_log', models.TextField(null=True, blank=True)),
                ('imported', models.DateTimeField(default=None, help_text='\u0415\u0441\u043b\u0438 \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0430, \u0437\u0430\u043d\u0447\u0438\u0442 \u0444\u0430\u0439\u043b \u0435\u0449\u0435 \u043d\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043b\u0441\u044f', null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0444\u0430\u0439\u043b\u0430', blank=True)),
                ('settlement', models.ForeignKey(verbose_name='\u0413\u043e\u0440\u043e\u0434', to='www.Settlement', help_text='\u0414\u043b\u044f \u043a\u0430\u043a\u043e\u0433\u043e \u0433\u043e\u0440\u043e\u0434\u0430 \u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043c\u0435\u0442\u0440\u043e')),
            ],
            options={
                'ordering': ('-imported',),
                'verbose_name': '\u0410.\u0424.: \u0424\u0430\u0439\u043b \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043c\u0435\u0442\u0440\u043e',
                'verbose_name_plural': '\u0410.\u0424.: \u0424\u0430\u0439\u043b\u044b \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043c\u0435\u0442\u0440\u043e',
            },
        ),
        migrations.CreateModel(
            name='AFUpdateFile',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('update_file_name', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430', blank=True)),
                ('update_file', common.utils.fields.TextFileField(help_text='\u041f\u0440\u0438\u043d\u0438\u043c\u0430\u044e\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0435 \u0444\u0430\u0439\u043b\u044b \u0432 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0435 cp1251', verbose_name='\u0424\u0430\u0439\u043b \u0441 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f\u043c\u0438')),
                ('load_log', models.TextField(null=True, blank=True)),
                ('added', models.DateTimeField(auto_now_add=True, verbose_name='\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d')),
                ('loaded', models.BooleanField(default=False, help_text='\u0415\u0441\u043b\u0438 False \u0442\u043e \u0444\u0430\u0439\u043b \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c\u0441\u044f \u043f\u0440\u0438 \u0435\u0436\u0435\u0434\u043d\u0435\u0432\u043d\u043e\u043c \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438', verbose_name='\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d')),
                ('recount_schedule_on_the_fly', models.BooleanField(default=False, verbose_name='\u041f\u0435\u0440\u0435\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c station_schedule \u043d\u0430 \u043b\u0435\u0442\u0443')),
            ],
            options={
                'ordering': ('-added',),
                'verbose_name': '\u042d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u043a\u0438: \u0424\u0430\u0439\u043b \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f',
                'verbose_name_plural': '\u042d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u043a\u0438: \u0424\u0430\u0439\u043b\u044b \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f',
            },
        ),
        migrations.CreateModel(
            name='AirportForAgentImport',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('update_frequency', models.CharField(default=b'1h', max_length=10, verbose_name='\u041e\u0431\u043d\u043e\u0432\u043b\u044f\u0442\u044c \u0440\u0430\u0437 \u0432', choices=[(b'1h', '1 \u0447\u0430\u0441'), (b'10min', '10 \u043c\u0438\u043d\u0443\u0442')])),
                ('station', models.ForeignKey(verbose_name='\u0410\u044d\u0440\u043e\u043f\u043e\u0440\u0442', to='www.Station')),
            ],
            options={
                'verbose_name': '\u0410\u044d\u0440\u043e\u043f\u043e\u0440\u0442 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0442\u0430\u0431\u043b\u043e \u043e\u0442 \u0410\u0433\u0435\u043d\u0442\u0430',
                'verbose_name_plural': '\u0421\u043f\u0438\u0441\u043e\u043a \u0430\u044d\u0440\u043e\u043f\u043e\u0440\u0442\u043e\u0432 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0442\u0430\u0431\u043b\u043e \u043e\u0442 \u0410\u0433\u0435\u043d\u0442\u0430',
            },
        ),
        migrations.CreateModel(
            name='BlackList',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', common.utils.fields.RegExpField(help_text='\u041d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043c\u044b \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u043c(\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0432\u0430\u0442\u044c \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u044b\u043c \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c)', max_length=100, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430', blank=True)),
                ('comment', models.TextField(help_text='\u0415\u0441\u043b\u0438 \u043d\u0438 \u043e\u0434\u043d\u043e \u043f\u043e\u043b\u0435 \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e, \u0438 \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u044b \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043d\u0438\u0442\u043e\u043a, \u043f\u043e\u0434 \u0447\u0435\u0440\u043d\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u0431\u0443\u0434\u0443\u0442 \u043f\u043e\u043f\u0430\u0434\u0430\u0442\u044c \u0432\u0441\u0435 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u044b \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430, \u0441 \u0434\u0430\u043d\u043d\u044b\u043c \u0442\u0438\u043f\u043e\u043c \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430!!!', verbose_name='\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439')),
                ('supplier_number', common.utils.fields.RegExpField(help_text='\u041d\u043e\u043c\u0435\u0440 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430, \u0435\u0441\u043b\u0438 \u043d\u0435 \u043e\u0431\u0449\u0438\u0439 XML \u0438\u043b\u0438 \u0442\u0440\u0435\u0443\u0433\u043e\u043b\u044c\u043d\u044b\u0439, \u0442\u043e \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0439 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 160x2_olven \u041e\u043b\u0432\u0435\u043d, ast01x103x1030 \u0414\u042e\u041a, 102 \u041a\u0430\u0440\u0430\u0433\u0430\u043d\u0434\u0430. (\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0432\u0430\u0442\u044c \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u044b\u043c \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c)', max_length=300, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430 \u0443 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430', blank=True)),
                ('supplier_title', common.utils.fields.RegExpField(help_text='\u041f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439, \u043e\u0431\u0440\u0435\u0437\u0430\u044e\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u044b. \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u044f \u043c\u043e\u0436\u0435\u0442 \u0441\u0442\u0440\u043e\u0438\u0442\u0441\u044f \u0438\u0437 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u0445 \u043f\u043e\u043b\u0435\u0439 \u0443 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 \u0443 \u0414\u042e\u041a \u0421\u041e\u041a\u041e\u041b - 1\u0412\u041e\u041b\u041e\u0413\u0414\u0410. (\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0432\u0430\u0442\u044c \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u044b\u043c \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c)', max_length=300, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u0439\u0441\u0430 \u0443 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430', blank=True)),
                ('start_time_start', models.TimeField(default=None, null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f \u0441\u0442\u0430\u0440\u0442\u0430 \u043d\u0438\u0442\u043a\u0438, \u043d\u0430\u0447\u0430\u043b\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430', blank=True)),
                ('start_time_end', models.TimeField(default=None, help_text='\u0415\u0441\u043b\u0438 \u043a\u043e\u043d\u0435\u0446 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d, \u0438\u0449\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u0441 \u043d\u0430\u0447\u0430\u043b\u043e\u043c \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430, \u0435\u0441\u043b\u0438 \u043d\u0430\u0447\u0430\u043b\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e, \u043a\u043e\u043d\u0435\u0446 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u0435\u0442\u0441\u044f.', null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f \u0441\u0442\u0430\u0440\u0442\u0430 \u043d\u0438\u0442\u043a\u0438, \u043a\u043e\u043d\u0435\u0446 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430', blank=True)),
                ('finish_time_start', models.TimeField(default=None, null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f \u043d\u0430 \u043a\u043e\u043d\u0435\u0447\u043d\u0443\u044e, \u043d\u0430\u0447\u0430\u043b\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430', blank=True)),
                ('finish_time_end', models.TimeField(default=None, help_text='\u0415\u0441\u043b\u0438 \u043a\u043e\u043d\u0435\u0446 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d, \u0438\u0449\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u0441 \u043d\u0430\u0447\u0430\u043b\u043e\u043c \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430, \u0435\u0441\u043b\u0438 \u043d\u0430\u0447\u0430\u043b\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e, \u043a\u043e\u043d\u0435\u0446 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u0435\u0442\u0441\u044f.', null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f \u043d\u0430 \u043a\u043e\u043d\u0435\u0447\u043d\u0443\u044e, \u043a\u043e\u043d\u0435\u0446 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430', blank=True)),
                ('is_moscow_time', models.BooleanField(default=False, help_text='\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u0432\u0440\u0435\u043c\u044f \u043c\u0435\u0441\u0442\u043d\u043e\u0435', verbose_name='\u041c\u043e\u0441\u043a\u043e\u0432\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f')),
                ('finish_station', models.ForeignKey(related_name='black_list_finish_stations', default=None, blank=True, to='www.Station', null=True, verbose_name='\u041a\u043e\u043d\u0435\u0447\u043d\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f')),
                ('start_station', models.ForeignKey(related_name='black_list_start_stations', default=None, blank=True, to='www.Station', null=True, verbose_name='\u041d\u0430\u0447\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f')),
                ('supplier', models.ForeignKey(verbose_name='\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a', to='www.Supplier')),
                ('t_type', models.ForeignKey(verbose_name='\u0422\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType')),
                ('thread_type', models.ForeignKey(blank=True, to='www.RThreadType', null=True)),
            ],
            options={
                'ordering': ('t_type', 'number'),
                'verbose_name': '\u0460: \u0420\u0435\u0439\u0441 \u0447\u0435\u0440\u043d\u043e\u0433\u043e \u0441\u043f\u0438\u0441\u043a\u0430',
                'verbose_name_plural': '\u0460: \u0427\u0435\u0440\u043d\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u0440\u0435\u0439\u0441\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='BlackListThreadStation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('departure_time_start', models.TimeField(default=None, null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f, \u043d\u0430\u0447\u0430\u043b\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430', blank=True)),
                ('departure_time_end', models.TimeField(default=None, help_text='\u0415\u0441\u043b\u0438 \u043a\u043e\u043d\u0435\u0446 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d, \u0438\u0449\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u0441 \u043d\u0430\u0447\u0430\u043b\u043e\u043c \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430, \u0435\u0441\u043b\u0438 \u043d\u0430\u0447\u0430\u043b\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e, \u043a\u043e\u043d\u0435\u0446 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u0435\u0442\u0441\u044f.', null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f, \u043a\u043e\u043d\u0435\u0446 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430', blank=True)),
                ('arrival_time_start', models.TimeField(default=None, null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f, \u043d\u0430\u0447\u0430\u043b\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430', blank=True)),
                ('arrival_time_end', models.TimeField(default=None, help_text='\u0415\u0441\u043b\u0438 \u043a\u043e\u043d\u0435\u0446 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d, \u0438\u0449\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u0441 \u043d\u0430\u0447\u0430\u043b\u043e\u043c \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430, \u0435\u0441\u043b\u0438 \u043d\u0430\u0447\u0430\u043b\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e, \u043a\u043e\u043d\u0435\u0446 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u0435\u0442\u0441\u044f.', null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f, \u043a\u043e\u043d\u0435\u0446 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430', blank=True)),
                ('is_moscow_time', models.BooleanField(default=False, help_text='\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u0432\u0440\u0435\u043c\u044f \u043c\u0435\u0441\u0442\u043d\u043e\u0435', verbose_name='\u041c\u043e\u0441\u043a\u043e\u0432\u0441\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f')),
                ('blacklist', models.ForeignKey(to='importinfo.BlackList')),
                ('station', models.ForeignKey(verbose_name='\u0421\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
            ],
            options={
                'verbose_name': '\u0421\u0442\u0430\u043d\u0446\u0438\u044f \u043d\u0438\u0442\u043a\u0438 \u0447\u0435\u0440\u043d\u043e\u0433\u043e \u0441\u043f\u0438\u0441\u043a\u0430',
                'verbose_name_plural': '\u0421\u0442\u0430\u043d\u0446\u0438\u0438 \u043d\u0438\u0442\u043a\u0438 \u0447\u0435\u0440\u043d\u043e\u0433\u043e \u0441\u043f\u0438\u0441\u043a\u0430',
            },
        ),
        migrations.CreateModel(
            name='BuscomuaStationCode',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('server_code', common.utils.fields.CodeCharField(default='', max_length=100, verbose_name='\u041a\u043e\u0434 \u0441\u0435\u0440\u0432\u0435\u0440\u0430')),
                ('city_code', common.utils.fields.CodeCharField(default='', max_length=100, verbose_name='\u041a\u043e\u0434 \u0433\u043e\u0440\u043e\u0434\u0430')),
                ('station_code', common.utils.fields.CodeCharField(default='', max_length=100, verbose_name='\u041a\u043e\u0434 \u0441\u0442\u0430\u043d\u0446\u0438\u0438')),
                ('station', models.ForeignKey(to='www.Station')),
            ],
            options={
                'verbose_name': '\u041a\u043e\u0434 \u0441\u0442\u0430\u043d\u0446\u0438\u0438',
                'verbose_name_plural': '\u0411\u0443\u0441\u041a\u043e\u043c\u0423\u0430: \u041a\u043e\u0434\u044b \u0441\u0442\u0430\u043d\u0446\u0438\u0438',
            },
        ),
        migrations.CreateModel(
            name='CodeshareNumber',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number_re', common.utils.fields.RegExpField(max_length=255, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430, \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435')),
                ('comment', models.TextField(verbose_name='\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439')),
                ('exclude_from_tablo_import', models.BooleanField(default=True, verbose_name='\u0418\u0441\u043a\u043b\u044e\u0447\u0430\u0442\u044c \u0438\u0437 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0430\u0431\u043b\u043e')),
            ],
            options={
                'db_table': 'importinfo_codeshareroute',
                'verbose_name': '\u041a\u043e\u0434\u0448\u0435\u0440\u0438\u043d\u0433\u043e\u0432\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430',
                'verbose_name_plural': '\u041a\u043e\u0434\u0448\u0435\u0440\u0438\u043d\u0433\u043e\u0432\u044b\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u0440\u0435\u0439\u0441\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='CompanyMapping',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', common.utils.fields.TrimmedCharField(default='', help_text='\u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0447\u0438\u0441\u0442\u0438\u0442\u0441\u044f \u043e\u0442 \u043b\u0438\u0448\u043d\u0438\u0445 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432', max_length=255, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438 \u0443 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430', blank=True)),
                ('code', common.utils.fields.TrimmedCharField(default='', help_text='\u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0447\u0438\u0441\u0442\u0438\u0442\u0441\u044f \u043e\u0442 \u043b\u0438\u0448\u043d\u0438\u0445 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432', max_length=255, verbose_name='\u043a\u043e\u0434 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438 \u0443 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430', blank=True)),
                ('company', models.ForeignKey(verbose_name='\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f', to='www.Company')),
                ('supplier', models.ForeignKey(verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a', to='www.Supplier')),
            ],
            options={
                'verbose_name': '\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435: \u041a\u043e\u043c\u043f\u0430\u043d\u0438\u0438 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0443',
                'verbose_name_plural': '\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f: \u041a\u043e\u043c\u043f\u0430\u043d\u0438\u044f\u043c \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430\u043c',
            },
        ),
        migrations.CreateModel(
            name='CompanySynonym',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', common.utils.fields.CodeCharField(max_length=255, verbose_name='\u0421\u0438\u043d\u043e\u043d\u0438\u043c')),
                ('company', models.ForeignKey(verbose_name='\u041a\u043e\u043c\u043f\u0430\u043d\u0438\u044f', to='www.Company')),
                ('t_type', models.ForeignKey(verbose_name='\u0422\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430', to='www.TransportType')),
            ],
            options={
                'verbose_name': '\u0460: \u0421\u0438\u043d\u043e\u043d\u0438\u043c \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430',
                'verbose_name_plural': '\u0460: \u0421\u0438\u043d\u043e\u043d\u0438\u043c\u044b \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='ContentManager',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=30, unique=True, null=True, verbose_name='\u0418\u043c\u044f')),
                ('email', models.EmailField(max_length=254, verbose_name='e-mail \u0430\u0434\u0440\u0435\u0441')),
            ],
            options={
                'verbose_name': '\u041a\u043e\u043d\u0442\u0435\u043d\u0442 \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440',
                'verbose_name_plural': '\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a "\u041a\u043e\u043d\u0442\u0435\u043d\u0442-\u041c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u044b"',
            },
        ),
        migrations.CreateModel(
            name='CysixGroupFilter',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(default='', max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b', blank=True)),
                ('code', common.utils.fields.CodeCharField(max_length=255, verbose_name='\u041a\u043e\u0434 \u0413\u0440\u0443\u043f\u043f\u044b')),
                ('tsi_middle_available', models.BooleanField(default=False, verbose_name='\u0418\u043c\u043f\u043e\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u043f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043e\u0447\u043d\u0443\u044e \u0431\u0430\u0437\u0443')),
                ('tsi_import_available', models.BooleanField(default=False, verbose_name='\u0418\u043c\u043f\u043e\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0447\u0435\u0440\u0435\u0437 \u0434\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u0442\u044b\u0439')),
                ('import_order_data', models.BooleanField(default=False, verbose_name='\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u043f\u043e\u043a\u0443\u043f\u043a\u0438 \u0431\u0438\u043b\u0435\u0442\u0430')),
                ('use_thread_in_station_code', models.BooleanField(default=False, verbose_name='\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u043d\u0438\u0442\u043a\u0438 \u0432 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u043a\u043e\u0434\u0430 \u0441\u0442\u0430\u043d\u0446\u0438\u0438')),
            ],
            options={
                'verbose_name': '\u0414\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u0413\u0440\u0443\u043f\u043f\u0430 \u043e\u0431\u0449\u0435\u0433\u043e \u0444\u043e\u0440\u043c\u0430\u0442\u0430',
                'verbose_name_plural': '\u0414\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0433\u0440\u0443\u043f\u043f\u0430\u043c \u043e\u0431\u0449\u0435\u0433\u043e \u0444\u043e\u0440\u043c\u0430\u0442\u0430',
            },
        ),
        migrations.CreateModel(
            name='DirectionSlice',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('direction_title', models.CharField(max_length=255, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f')),
                ('last_mask_date', models.DateField(verbose_name='\u0414\u0430\u0442\u0430, \u043f\u043e\u0441\u043b\u0435 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0432\u0441\u0435 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u0438 \u043d\u0438\u0442\u043e\u043a \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0431\u0443\u0434\u0443\u0442 \u043f\u0443\u0441\u0442\u044b\u043c\u0438')),
                ('starts_quantity', models.IntegerField(verbose_name='\u0421\u0443\u043c\u043c\u0430\u0440\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0442\u0430\u0440\u0442\u043e\u0432 \u043d\u0438\u0442\u043e\u043a \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f, \u043d\u0430\u0447\u0438\u043d\u0430\u044f \u0441 \u0434\u0430\u0442\u044b \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0437\u0430')),
            ],
            options={
                'verbose_name': '\u0414\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u0421\u0440\u0435\u0437 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                'verbose_name_plural': '\u0414\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u0421\u0440\u0435\u0437\u044b \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='EtrafficMainBusStationInGroup',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('group_code', common.utils.fields.TrimmedCharField(help_text='\u041d\u0443\u0436\u043d\u043e \u0437\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043a\u0430\u043a \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0432 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430', unique=True, max_length=255, verbose_name='\u041a\u043e\u0434 \u0433\u0440\u0443\u043f\u043f\u044b')),
                ('code', common.utils.fields.TrimmedCharField(help_text='\u041d\u0443\u0436\u043d\u043e \u0437\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043a\u0430\u043a \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0432 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430', max_length=255, verbose_name='\u041a\u043e\u0434 \u0433\u043b\u0430\u0432\u043d\u043e\u0433\u043e \u0430\u0432\u0442\u043e\u0432\u043e\u043a\u0437\u0430\u043b\u0430 \u0433\u0440\u0443\u043f\u043f\u044b')),
                ('title', common.utils.fields.TrimmedCharField(help_text='\u041d\u0443\u0436\u043d\u043e \u0437\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043a\u0430\u043a \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0432 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430', max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u043b\u0430\u0432\u043d\u043e\u0433\u043e \u0430\u0432\u0442\u043e\u0432\u043e\u043a\u0437\u0430\u043b\u0430 \u0433\u0440\u0443\u043f\u043f\u044b')),
                ('action_on_thread_without_main_station', models.CharField(default=b'skip', help_text='\u0412\u044b\u0441\u0442\u0430\u0432\u043b\u044f\u0439\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0433\u043b\u0430\u0432\u043d\u044b\u0439 \u0430\u0432\u0442\u043e\u0432\u043e\u043a\u0437\u0430\u043b \u043f\u0435\u0440\u0432\u043e\u0439 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u043e\u0439 \u0432 \u043d\u0438\u0442\u043a\u0443" \u0442\u043e\u043b\u044c\u043a\u043e, \u0435\u0441\u043b\u0438 \u043a\u043e\u0434 \u0438 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u043b\u0430\u0432\u043d\u043e\u0433\u043e \u0430\u0432\u0442\u043e\u0432\u043e\u043a\u0437\u0430\u043b\u0430 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u044b \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e.', max_length=10, verbose_name='\u0427\u0442\u043e \u0434\u0435\u043b\u0430\u0442\u044c, \u0435\u0441\u043b\u0438 \u0432 \u043d\u0438\u0442\u043a\u0435 \u043d\u0435\u0442 \u0433\u043b\u0430\u0432\u043d\u043e\u0433\u043e \u0430\u0432\u0442\u043e\u0432\u043e\u043a\u0437\u0430\u043b\u0430 \u0433\u0440\u0443\u043f\u043f\u044b', choices=[(b'skip', '\u041f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0442\u044c \u043d\u0438\u0442\u043a\u0443'), (b'add_first', '\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0433\u043b\u0430\u0432\u043d\u044b\u0439 \u0430\u0432\u0442\u043e\u0432\u043e\u043a\u0437\u0430\u043b \u043f\u0435\u0440\u0432\u043e\u0439 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u043e\u0439 \u0432 \u043d\u0438\u0442\u043a\u0443')])),
            ],
            options={
                'verbose_name': 'E-traffic: \u0413\u043b\u0430\u0432\u043d\u044b\u0439 \u0430\u0432\u0442\u043e\u0432\u043e\u043a\u0437\u0430\u043b \u0433\u0440\u0443\u043f\u043f\u044b',
                'verbose_name_plural': 'E-traffic: \u0413\u043b\u0430\u0432\u043d\u044b\u0435 \u0430\u0432\u0442\u043e\u0432\u043e\u043a\u0437\u0430\u043b\u044b \u0433\u0440\u0443\u043f\u043f\u044b',
            },
        ),
        migrations.CreateModel(
            name='Express2Country',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code_re', common.utils.fields.RegExpField(max_length=255, verbose_name='\u0420\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435, \u043a\u043e\u0434 \u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u0430')),
                ('priority', models.IntegerField(default=0, help_text='\u0427\u0435\u043c \u0432\u044b\u0448\u0435 \u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442, \u0442\u0435\u043c \u0440\u0430\u043d\u044c\u0448\u0435 \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435, \u043a\u0430\u043a \u0442\u043e\u043b\u044c\u043a\u043e \u043c\u044b \u043d\u0430\u0445\u043e\u0434\u0438\u043c \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0435 \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435, \u0441\u0440\u0430\u0437\u0443 \u0436\u0435 \u0432\u044b\u0445\u043e\u0434\u0438\u043c', verbose_name='\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442')),
                ('time_zone', models.CharField(max_length=30, blank=True, help_text='\u0415\u0441\u043b\u0438 \u043d\u0443\u0436\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u0443\u044e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e \u0437\u043e\u043d\u0443 \u0432\u043d\u0435 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u043e\u0442 \u0441\u0442\u0440\u0430\u043d\u044b, \u0434\u0430\u0436\u0435 \u0435\u0441\u043b\u0438 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0430 \u0437\u043e\u043d\u0430 \u0432\u043e\u0437\u044c\u043c\u0435\u0442\u0441\u044f \u043e\u0442 \u0441\u044e\u0434\u0430.', null=True, verbose_name='\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430')),
                ('comment', models.TextField(null=True, verbose_name='\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439', blank=True)),
                ('country', models.ForeignKey(verbose_name='\u0421\u0442\u0440\u0430\u043d\u0430', to='www.Country')),
            ],
            options={
                'ordering': ('-priority', 'code_re'),
                'verbose_name': '\u041f\u043e\u0435\u0437\u0434\u0430: \u041a\u043e\u0434 \u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u0430 - \u0421\u0442\u0440\u0430\u043d\u0430',
                'verbose_name_plural': '\u041f\u043e\u0435\u0437\u0434\u0430: \u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0432\u0438\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445 \u0437\u043e\u043d \u0438 \u043a\u043e\u0434\u043e\u0432 \u042d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u0430',
            },
        ),
        migrations.CreateModel(
            name='IataCorrection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', common.utils.fields.CodeCharField(max_length=4, verbose_name='\u041a\u043e\u0434 IATA')),
                ('number', common.utils.fields.RegExpField(help_text='\u041d\u043e\u043c\u0435\u0440 \u0431\u0435\u0437 \u043a\u043e\u0434\u0430. \u041c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0432\u0430\u0442\u044c \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u044b\u043c \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c', max_length=1000, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430')),
                ('company', models.ForeignKey(to='www.Company')),
            ],
            options={
                'verbose_name': '\u041a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u044f IATA \u043a\u043e\u0434\u0430',
                'verbose_name_plural': '\u041a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u0438 IATA \u043a\u043e\u0434\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='ImportReport',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('imported', models.DateTimeField(auto_now_add=True, verbose_name='\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u0435\u043d\u0438\u044f \u043e\u0442\u0447\u0435\u0442\u0430')),
                ('route_set', travel.rasp.admin.lib.fields.PickledObjectField(verbose_name='\u0421\u043f\u0438\u0441\u043e\u043a \u0440\u0435\u0439\u0441\u043e\u0432', null=True, editable=False)),
                ('route_count', models.IntegerField(default=0, verbose_name='\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0440\u0435\u0439\u0441\u043e\u0432', editable=False)),
                ('supplier', models.ForeignKey(editable=False, to='www.Supplier', verbose_name='\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a')),
            ],
            options={
                'ordering': ('-imported',),
                'verbose_name': '\u0460: \u041e\u0442\u0447\u0435\u0442 \u0438\u043c\u043f\u043e\u0440\u0442\u0430',
                'verbose_name_plural': '\u0460: \u041e\u0442\u0447\u0435\u0442\u044b \u043e \u0438\u043c\u043f\u043e\u0440\u0442\u0435',
            },
            bases=(models.Model, travel.rasp.admin.importinfo.models.model_extenders.ImportReportExtender),
        ),
        migrations.CreateModel(
            name='IpekturStopsOrder',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('original_order', models.TextField(verbose_name='\u041f\u043e\u0440\u044f\u0434\u043e\u043a \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043e\u043a \u0432 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0442 ipektur')),
                ('right_order', models.TextField(default=b'', verbose_name='\u041f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043e\u043a', blank=True)),
                ('use', models.BooleanField(default=False, help_text='\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043c\u0435\u043d\u0443 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043e\u043a', verbose_name='\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c')),
            ],
            options={
                'verbose_name': 'Ipektur: \u041f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043e\u043a',
                'verbose_name_plural': 'Ipektur: \u041f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043e\u043a',
            },
        ),
        migrations.CreateModel(
            name='MappingContext',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('route_number', common.utils.fields.TrimmedCharField(default='', max_length=255, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430', blank=True)),
                ('route_title', common.utils.fields.TrimmedCharField(default='', max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430', blank=True)),
                ('first_station_code', common.utils.fields.TrimmedCharField(default='', max_length=255, verbose_name='\u041a\u043e\u0434 \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', blank=True)),
                ('first_station_title', common.utils.fields.TrimmedCharField(default='', max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', blank=True)),
                ('last_station_code', common.utils.fields.TrimmedCharField(default='', max_length=255, verbose_name='\u041a\u043e\u0434 \u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', blank=True)),
                ('last_station_title', common.utils.fields.TrimmedCharField(default='', max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', blank=True)),
                ('priority', models.IntegerField(default=0, verbose_name='\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442', blank=True)),
                ('supplier', models.ForeignKey(verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a', to='www.Supplier')),
            ],
            options={
                'verbose_name': '\u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0432\u0438\u044f',
                'verbose_name_plural': '\u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u044b \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0432\u0438\u044f',
            },
        ),
        migrations.CreateModel(
            name='MTADistrictMapping',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('area_code', common.utils.fields.CodeCharField(unique=True, max_length=255)),
                ('area_name', models.CharField(max_length=255)),
                ('district', models.ForeignKey(blank=True, to='www.District', null=True)),
                ('region', models.ForeignKey(blank=True, to='www.Region', null=True)),
            ],
            options={
                'verbose_name': '\u043c\u0422\u0410: \u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0440\u0430\u0439\u043e\u043d\u0430',
                'verbose_name_plural': '\u043c\u0422\u0410: \u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f \u0440\u0430\u0439\u043e\u043d\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='MTAInternalNumberBlackList',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', common.utils.fields.RegExpField(help_text='\u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430 \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0432\u0430\u0442\u044c \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u044b\u043c \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c', max_length=100, verbose_name='\u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430')),
                ('comment', models.CharField(default=None, max_length=255, null=True, verbose_name='\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435', blank=True)),
            ],
            options={
                'verbose_name': '\u043c\u0422\u0410: \u041d\u043e\u043c\u0435\u0440 \u0447\u0435\u0440\u043d\u043e\u0433\u043e \u0441\u043f\u0438\u0441\u043a\u0430',
                'verbose_name_plural': '\u043c\u0422\u0410: \u0427\u0435\u0440\u043d\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0445 \u043d\u043e\u043c\u0435\u0440\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='MTASettlementMapping',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('area_code', common.utils.fields.CodeCharField(max_length=255)),
                ('stop_city', common.utils.fields.CodeCharField(max_length=255)),
                ('region', models.ForeignKey(blank=True, to='www.Region', null=True)),
                ('settlement', models.ForeignKey(to='www.Settlement', null=True)),
            ],
            options={
                'verbose_name': '\u043c\u0422\u0410: \u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0433\u043e\u0440\u043e\u0434\u0430',
                'verbose_name_plural': '\u043c\u0422\u0410: \u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f \u0433\u043e\u0440\u043e\u0434\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='OriginalThreadData',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('thread_uid', models.CharField(max_length=255, editable=False, db_index=True)),
                ('cysix', models.TextField(default=None, null=True, editable=False, blank=True)),
                ('raw', models.TextField(default=None, null=True, editable=False, blank=True)),
            ],
            options={
                'verbose_name': '\u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043d\u0438\u0442\u043a\u0438',
                'verbose_name_plural': '\u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043d\u0438\u0442\u043e\u043a',
            },
        ),
        migrations.CreateModel(
            name='PackageDirectionsSlice',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('creation_dt', models.DateTimeField(verbose_name='\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0437\u0430')),
            ],
            options={
                'verbose_name': '\u0414\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u0421\u0440\u0435\u0437 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439 \u043f\u0430\u043a\u0435\u0442\u0430',
                'verbose_name_plural': '\u0414\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u0421\u0440\u0435\u0437\u044b \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439 \u043f\u0430\u043a\u0435\u0442\u0430',
            },
        ),
        migrations.CreateModel(
            name='RelatedLog',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('object_id', models.PositiveIntegerField(default=None, null=True, blank=True)),
                ('code', common.utils.fields.CodeCharField(default=None, max_length=255, blank=True, help_text='\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0442\u043e\u043c \u0441\u043b\u0443\u0447\u0430\u0435 \u0435\u0441\u043b\u0438 \u043e\u0431\u044a\u0435\u043a\u0442 \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043b\u043e\u0433\u043e\u0432', null=True, verbose_name='\u041a\u043e\u0434')),
                ('tag', common.utils.fields.CodeCharField(default=None, max_length=255, blank=True, help_text='\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0442\u043e\u043c \u0441\u043b\u0443\u0447\u0430\u0435 \u0435\u0441\u043b\u0438 \u043e\u0431\u044a\u0435\u043a\u0442 \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043b\u043e\u0433\u043e\u0432', null=True, verbose_name='\u0422\u0435\u0433')),
                ('log_field_ru', models.TextField(verbose_name='\u041b\u043e\u0433 \u043d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c', db_column=b'log_field')),
                ('log_field_en', models.TextField(default=b'', verbose_name='\u041b\u043e\u0433 \u043d\u0430 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u043c')),
                ('content_type', models.ForeignKey(default=None, blank=True, to='contenttypes.ContentType', null=True)),
            ],
            options={
                'verbose_name': '\u0460: \u041b\u043e\u0433 \u043e\u0431\u044a\u0435\u043a\u0442\u0430',
                'verbose_name_plural': '\u0460: \u041b\u043e\u0433\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='Route2Terminal',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', common.utils.fields.TrimmedCharField(max_length=255, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430')),
                ('terminal', models.ForeignKey(verbose_name='\u0422\u0435\u0440\u043c\u0438\u043d\u0430\u043b', to='www.StationTerminal')),
            ],
            options={
                'verbose_name': '\u0460: \u041f\u0440\u0438\u0432\u044f\u0437\u043a\u0430 \u0440\u0435\u0439\u0441\u043a\u0430 \u043a \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0443',
                'verbose_name_plural': '\u0460: \u041f\u0440\u0438\u0432\u044f\u0437\u043a\u0438 \u0440\u0435\u0439\u0441\u043e\u0432 \u043a \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430\u043c',
            },
            bases=(models.Model, travel.rasp.admin.importinfo.models.model_extenders.Route2TerminalExtender),
        ),
        migrations.CreateModel(
            name='StationMapping',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', common.utils.fields.TrimmedCharField(default='', help_text='\u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0447\u0438\u0441\u0442\u0438\u0442\u0441\u044f \u043e\u0442 \u043b\u0438\u0448\u043d\u0438\u0445 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432', max_length=255, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u0443 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430', blank=True)),
                ('code', common.utils.fields.TrimmedCharField(default='', help_text='\u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0447\u0438\u0441\u0442\u0438\u0442\u0441\u044f \u043e\u0442 \u0432\u0441\u0435\u0445 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432', max_length=255, verbose_name='\u043a\u043e\u0434 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u0443 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430', blank=True)),
                ('number', common.utils.fields.RegExpField(default=None, max_length=100, blank=True, help_text='\u0440\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435', null=True, verbose_name='\u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430')),
                ('route_title', common.utils.fields.RegExpField(default=None, max_length=255, blank=True, help_text='\u0440\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435', null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u0439\u0441\u0430')),
                ('context', models.ForeignKey(default=None, blank=True, to='importinfo.MappingContext', null=True)),
                ('region', models.ForeignKey(default=None, to='www.Region', blank=True, help_text='\u0440\u0435\u0433\u0438\u043e\u043d \u0440\u0435\u0439\u0441\u0430, \u0435\u0441\u043b\u0438 \u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d \u043d\u0430 \u043c\u043e\u043c\u0435\u043d\u0442 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f', null=True, verbose_name='\u0440\u0435\u0433\u0438\u043e\u043d \u0440\u0435\u0439\u0441\u0430')),
                ('station', models.ForeignKey(verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
                ('supplier', models.ForeignKey(verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a', to='www.Supplier')),
            ],
            options={
                'db_table': 'importinfo_busstationtitlemapping',
                'verbose_name': '\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435: \u0421\u0442\u0430\u043d\u0446\u0438\u0438',
                'verbose_name_plural': '\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f: \u0421\u0442\u0430\u043d\u0446\u0438\u044f\u043c',
            },
        ),
        migrations.CreateModel(
            name='TabloImportSynonym',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430')),
                ('settlement', models.ForeignKey(verbose_name='\u0413\u043e\u0440\u043e\u0434', blank=True, to='www.Settlement', null=True)),
                ('station', models.ForeignKey(verbose_name='\u0421\u0442\u0430\u043d\u0446\u0438\u044f', blank=True, to='www.Station', null=True)),
                ('supplier', models.ForeignKey(verbose_name='\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a \u0442\u0430\u0431\u043b\u043e', to='www.Supplier')),
            ],
            options={
                'verbose_name': '\u0422\u0430\u0431\u043b\u043e: \u0421\u0438\u043d\u043e\u043d\u0438\u043c \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430',
                'verbose_name_plural': '\u0422\u0430\u0431\u043b\u043e: \u0421\u0438\u043d\u043e\u043d\u0438\u043c\u044b \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430',
            },
        ),
        migrations.CreateModel(
            name='TabloManualStatus',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('event', models.CharField(max_length=50, verbose_name='\u0421\u043e\u0431\u044b\u0442\u0438\u0435', choices=[(b'arrival', '\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u0435'), (b'departure', '\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435')])),
                ('number', common.utils.fields.RegExpField(help_text='\u0420\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435', max_length=100, verbose_name='\u041d\u043e\u043c\u0435\u0440')),
                ('planned', models.DateTimeField(verbose_name='\u0412\u0440\u0435\u043c\u044f \u043f\u043e \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044e')),
                ('real', models.DateTimeField(verbose_name='\u0412\u0440\u0435\u043c\u044f \u0444\u0430\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435')),
                ('status', models.CharField(max_length=20, verbose_name='\u0421\u0442\u0430\u0442\u0443\u0441', choices=[(b'use_real_time', '\u0412\u0438\u0447\u0438\u0441\u043b\u0438\u0442\u044c \u043f\u043e \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u043c\u0443 \u0432\u0440\u0435\u043c\u0435\u043d\u0438'), (b'cancelled', '\u041e\u0442\u043c\u0435\u043d\u0435\u043d'), (b'hidden', '\u0421\u043a\u0440\u044b\u0442')])),
                ('station', models.ForeignKey(verbose_name='\u0421\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
            ],
            options={
                'verbose_name': '\u0422\u0430\u0431\u043b\u043e: \u0420\u0443\u0447\u043d\u043e\u0439 \u0441\u0442\u0430\u0442\u0443\u0441',
                'verbose_name_plural': '\u0422\u0430\u0431\u043b\u043e: \u0420\u0443\u0447\u043d\u044b\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u044b',
            },
            bases=(models.Model, travel.rasp.admin.importinfo.models.model_extenders.TabloManualStatusExtender),
        ),
        migrations.CreateModel(
            name='TariffFile',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('tariff_file_name', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430', blank=True)),
                ('tariff_file', common.utils.fields.TextFileField(default=b'', help_text='\u041f\u0440\u0438\u043d\u0438\u043c\u0430\u044e\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0435 \u0444\u0430\u0439\u043b\u044b \u0432 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0435 cp1251', null=True, verbose_name='\u0424\u0430\u0439\u043b \u0441 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f\u043c\u0438', blank=True)),
                ('tariff_rich_file', common.utils.fields.DatabaseFileField(help_text='\u041f\u0440\u0438\u043d\u0438\u043c\u0430\u0435\u043c \u0444\u0430\u0439\u043b\u044b xml, \u0432 \u0442\u043e\u043c \u0447\u0438\u0441\u043b\u0435 \u0432 \u0441\u0436\u0430\u0442\u043e\u043c \u0432\u0438\u0434\u0435 file.xml.gz', null=True, verbose_name='\u0424\u0430\u0439\u043b \u0441 \u0442\u0430\u0440\u0438\u0444\u0430\u043c\u0438', blank=True)),
                ('added', models.DateTimeField(auto_now_add=True, verbose_name='\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d')),
                ('load_log', models.TextField(null=True, blank=True)),
                ('imported', models.DateTimeField(default=None, help_text='\u0415\u0441\u043b\u0438 \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0430, \u0437\u0430\u043d\u0447\u0438\u0442 \u0444\u0430\u0439\u043b \u0435\u0449\u0435 \u043d\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043b\u0441\u044f', null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0444\u0430\u0439\u043b\u0430', blank=True)),
            ],
            options={
                'ordering': ('-added',),
                'verbose_name': '\u042d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u043a\u0438: \u0424\u0430\u0439\u043b \u0441 \u0442\u0430\u0440\u0438\u0444\u0430\u043c\u0438',
                'verbose_name_plural': '\u042d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u043a\u0438: \u0424\u0430\u0439\u043b\u044b \u0442\u0430\u0440\u0438\u0444\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='TrainTransportOverride',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', common.utils.fields.RegExpField(help_text='\u0420\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435', max_length=400, verbose_name='\u041d\u043e\u043c\u0435\u0440')),
                ('t_subtype', models.ForeignKey(default=None, blank=True, to='www.TransportSubtype', null=True, verbose_name='\u041f\u043e\u0434\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430')),
                ('t_type', models.ForeignKey(verbose_name='\u0422\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType')),
            ],
        ),
        migrations.CreateModel(
            name='TransportModelMapping',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', common.utils.fields.TrimmedCharField(default='', help_text='\u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0447\u0438\u0441\u0442\u0438\u0442\u0441\u044f \u043e\u0442 \u043b\u0438\u0448\u043d\u0438\u0445 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432', max_length=255, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043c\u043e\u0434\u0435\u043b\u0438 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430 \u0443 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430', blank=True)),
                ('code', common.utils.fields.TrimmedCharField(default='', help_text='\u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0447\u0438\u0441\u0442\u0438\u0442\u0441\u044f \u043e\u0442 \u043b\u0438\u0448\u043d\u0438\u0445 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432', max_length=255, verbose_name='\u043a\u043e\u0434 \u043c\u043e\u0434\u0435\u043b\u0438 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430 \u0443 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430', blank=True)),
                ('supplier', models.ForeignKey(verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a', to='www.Supplier')),
                ('t_model', models.ForeignKey(verbose_name='\u043c\u043e\u0434\u0435\u043b\u044c \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportModel')),
            ],
            options={
                'verbose_name': '\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435: \u041c\u043e\u0434\u0435\u043b\u0438 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
                'verbose_name_plural': '\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f: \u041c\u043e\u0434\u0435\u043b\u044f\u043c \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
            },
        ),
        migrations.CreateModel(
            name='TriangleBusImportPackage',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('supplier_email', models.EmailField(max_length=254, null=True, verbose_name='E-mail \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430', blank=True)),
                ('notify_supplier', models.BooleanField(default=False, verbose_name='\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u044f\u0442\u044c \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430')),
                ('encoding', models.CharField(default=None, choices=[(b'utf-8', b'utf-8'), (b'cp1251', b'cp1251')], max_length=20, blank=True, null=True, verbose_name='\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430')),
                ('title', models.CharField(default=None, max_length=255, blank=True, help_text='\u043d\u0435 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e, \u0435\u0441\u043b\u0438 \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e, \u043f\u0440\u0438\u0441\u0432\u0430\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430', null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u043a\u0435\u0442\u0430')),
                ('package_file', common.utils.fields.DatabaseFileField(default=None, null=True, verbose_name='\u0424\u0430\u0439\u043b \u043f\u0430\u043a\u0435\u0442\u0430', blank=True, validators=[travel.rasp.admin.importinfo.models.validators.triangle_file_validator])),
                ('test_run', models.BooleanField(default=True, help_text='\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u0434\u0435\u043b\u0430\u0435\u0442\u0441\u044f \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0437\u0430\u043f\u0443\u0441\u043a, \u0447\u0442\u043e\u0431\u044b \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0438 \u0441\u0442\u0430\u0446\u0438\u0438, \u0441\u043d\u0438\u043c\u0438\u0442\u0435 \u0444\u043b\u0430\u0433', verbose_name='\u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0437\u0430\u043f\u0443\u0441\u043a')),
                ('load_log', models.TextField(null=True, blank=True)),
                ('test_load_log', models.TextField(null=True, blank=True)),
                ('last_import_date', models.DateField(null=True, verbose_name='\u0414\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0438\u043c\u043f\u043e\u0440\u0442\u0430', blank=True)),
                ('last_mask_date', models.DateField(null=True, verbose_name='\u0414\u0430\u0442\u0430, \u043f\u043e\u0441\u043b\u0435 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0432\u0441\u0435 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u0438 \u043d\u0438\u0442\u043e\u043a \u0431\u0443\u0434\u0443\u0442 \u043f\u0443\u0441\u0442\u044b\u043c\u0438', blank=True)),
                ('recreate_stations', models.BooleanField(default=False, verbose_name='\u041f\u0435\u0440\u0435\u0441\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u0441\u0442\u0430\u043d\u0446\u0438\u0438, \u0434\u0430\u0436\u0435 \u0435\u0441\u043b\u0438 \u0435\u0441\u0442\u044c \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f')),
                ('import_on_save', models.BooleanField(default=False, verbose_name='\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438')),
                ('content_manager', models.ForeignKey(default=None, blank=True, to='importinfo.ContentManager', null=True, verbose_name='\u041e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0439 \u043a\u043e\u043d\u0442\u0435\u043d\u0442-\u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440')),
                ('country', models.ForeignKey(default=None, blank=True, to='www.Country', null=True, verbose_name='\u0441\u0442\u0440\u0430\u043d\u0430')),
                ('currency', models.ForeignKey(verbose_name='\u0412\u0430\u043b\u044e\u0442\u0430', blank=True, to='currency.Currency', null=True)),
                ('station_code_supplier', models.ForeignKey(related_name='trianglebusimportpackage_stationcodesupplier_set', default=None, to='www.Supplier', blank=True, help_text='\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0432\u0438\u044f \u0438 \u043a\u043e\u0434\u044b \u044d\u0442\u043e\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u0449\u0438\u043a\u0430 \u0431\u0443\u0434\u0443\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u0434\u043b\u044f \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u0439', null=True, verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a \u043a\u043e\u0434\u043e\u0432 \u0441\u0442\u0430\u043d\u0446\u0438\u0439')),
                ('supplier', models.ForeignKey(related_name='trianglebusimportpackage_set', default=None, blank=True, to='www.Supplier', null=True, verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445')),
                ('t_type', models.ForeignKey(default=3, verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType')),
            ],
            options={
                'verbose_name': '\u0442\u0440\u0435\u0443\u0433\u043e\u043b\u044c\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u041f\u0430\u043a\u0435\u0442',
                'verbose_name_plural': '\u0442\u0440\u0435\u0443\u0433\u043e\u043b\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u041f\u0430\u043a\u0435\u0442\u044b',
            },
        ),
        migrations.CreateModel(
            name='TSISetting',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('set_number', models.BooleanField(default=False, help_text='\u041f\u0440\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u043e\u0439 \u043e\u043f\u0446\u0438\u0438 \u043d\u0443\u0436\u043d\u043e \u0441\u0442\u0435\u0440\u0435\u0442\u044c \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u044b \u043f\u0430\u043a\u0435\u0442\u0430, \u043f\u0435\u0440\u0435\u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u043f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043e\u0447\u043d\u0443\u044e \u0438 \u043f\u0435\u0440\u0435\u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0430\u043a\u0435\u0442.', verbose_name='\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c')),
                ('filter_by_group', models.BooleanField(default=False, verbose_name='\u0424\u0438\u043b\u044c\u0442\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043e \u0433\u0440\u0443\u043f\u043f\u0430\u043c')),
                ('import_order_data', models.BooleanField(default=False, verbose_name='\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u043f\u043e\u043a\u0443\u043f\u043a\u0438 \u0431\u0438\u043b\u0435\u0442\u043e\u0432')),
                ('leave_days_in_past', models.IntegerField(default=0, verbose_name='\u041e\u0441\u0442\u0430\u0432\u043b\u044f\u0442\u044c \u0434\u043d\u0435\u0439 \u0432 \u043f\u0440\u043e\u0448\u043b\u043e\u043c')),
                ('update_threads', models.BooleanField(default=True, help_text='\u041f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438, \u0443 \u0441\u0442\u0430\u0440\u044b\u0445 \u043d\u0438\u0442\u043e\u043a, \u0441\u043d\u0438\u043c\u0430\u044e\u0442\u0441\u044f \u0434\u043d\u0438 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f, \u0437\u0430\u0442\u0435\u043c \u043d\u0430\u043a\u043b\u0430\u0434\u044b\u0432\u0430\u044e\u0442\u0441\u044f \u043d\u043e\u0432\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435. \u0415\u0441\u043b\u0438 \u0441\u043d\u044f\u0442\u044c \u0433\u0430\u043b\u043a\u0443 \u0442\u043e \u043d\u0438\u0442\u043a\u0438 \u0431\u0443\u0434\u0443\u0442 \u0443\u0434\u0430\u043b\u044f\u0442\u044c\u0441\u044f, \u043f\u0435\u0440\u0435\u0434 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u043e\u0439 \u043d\u043e\u0432\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445.', verbose_name='\u041e\u0431\u043d\u043e\u0432\u043b\u044f\u0442\u044c \u043d\u0438\u0442\u043a\u0438')),
                ('mark_new_company_as_strange', models.BooleanField(default=True, verbose_name='\u041f\u043e\u043c\u0435\u0447\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0435 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438 \u043a\u0430\u043a \u0441\u0442\u0440\u0430\u043d\u043d\u044b\u0435')),
                ('show_in_alldays_pages', models.BooleanField(default=True, verbose_name='\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0432 \u043f\u043e\u0438\u0441\u043a\u0435 \u0438 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0438 \u043d\u0430 \u0432\u0441\u0435 \u0434\u043d\u0438')),
                ('max_forward_days', models.IntegerField(default=300, help_text='\u0441\u0447\u0438\u0442\u0430\u044f \u0441 \u0434\u043d\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430', verbose_name='\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043d\u0435\u0439 \u0432\u043f\u0435\u0440\u0435\u0434, \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u044e\u0442\u0441\u044f \u0438\u043b\u0438 \u044d\u043a\u0441\u0442\u0440\u0430\u043f\u043e\u043b\u0438\u0440\u0443\u044e\u0442\u0441\u044f \u043c\u0430\u0441\u043a\u0438 \u043d\u0438\u0442\u043e\u043a')),
            ],
            options={
                'verbose_name': '\u0434\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438',
                'verbose_name_plural': '\u0434\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u043f\u0430\u043a\u0435\u0442\u0430(\u0442\u043e\u043b\u044c\u043a\u043e \u0435\u0441\u043b\u0438 \u0435\u0441\u0442\u044c \u043e\u0431\u0449\u0438\u0439 xml \u0444\u043e\u0440\u043c\u0430\u0442)',
            },
        ),
        migrations.CreateModel(
            name='TSIThreadSetting',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('path_key', models.TextField(verbose_name='\u041a\u043b\u044e\u0447 \u043f\u0443\u0442\u0438', db_index=False)),
                ('allow_to_import', models.BooleanField(default=True, verbose_name='\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c')),
                ('apply_base_stations', models.BooleanField(default=True, verbose_name='\u0423\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \xab\u0431\u0430\u0437\u043e\u0432\u043e\u0441\u0442\u044c\xbb \u0430\u0432\u0442\u043e\u0432\u043e\u043a\u0437\u0430\u043b\u043e\u0432')),
                ('timezone_override', models.CharField(default='none', max_length=100)),
            ],
            options={
                'verbose_name': '\u0414\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043d\u0438\u0442\u043a\u0438',
                'verbose_name_plural': '\u0414\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043d\u0438\u0442\u043a\u0438',
            },
        ),
        migrations.CreateModel(
            name='TSIThreadStationFlag',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('path_key', models.TextField(verbose_name='\u041a\u043b\u044e\u0447 \u043f\u0443\u0442\u0438', db_index=False)),
                ('station_key', models.CharField(max_length=500, verbose_name='\u041a\u043b\u044e\u0447 \u0441\u0442\u0430\u043d\u0446\u0438\u0438')),
                ('is_fuzzy', models.NullBooleanField(default=None, verbose_name='\u043d\u0435\u0447\u0435\u0442\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f/\u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', choices=[(None, '\u041d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u044c'), (True, '\u0414\u0430'), (False, '\u041d\u0435\u0442')])),
                ('is_searchable_from', models.NullBooleanField(default=None, verbose_name='\u0438\u0441\u043a\u0430\u0442\u044c \u043e\u0442 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', choices=[(None, '\u041d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u044c'), (True, '\u0414\u0430'), (False, '\u041d\u0435\u0442')])),
                ('is_searchable_to', models.NullBooleanField(default=None, verbose_name='\u0438\u0441\u043a\u0430\u0442\u044c \u0434\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438', choices=[(None, '\u041d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u044c'), (True, '\u0414\u0430'), (False, '\u041d\u0435\u0442')])),
                ('in_station_schedule', models.NullBooleanField(default=None, verbose_name='\u0432 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0438 \u043f\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438', choices=[(None, '\u041d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u044c'), (True, '\u0414\u0430'), (False, '\u041d\u0435\u0442')])),
                ('in_thread', models.NullBooleanField(default=None, verbose_name='\u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0438\u0442\u043a\u0438', choices=[(None, '\u041d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u044c'), (True, '\u0414\u0430'), (False, '\u041d\u0435\u0442')])),
            ],
            options={
                'verbose_name': '\u0434\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u041f\u0440\u0438\u0437\u043d\u0430\u043a\u0438 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043d\u0438\u0442\u043a\u0438',
                'verbose_name_plural': '\u0434\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u041f\u0440\u0438\u0437\u043d\u0430\u043a\u0438 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 \u043d\u0438\u0442\u043e\u043a',
            },
        ),
        migrations.CreateModel(
            name='TwoStageImportPackage',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u043a\u0435\u0442\u0430')),
                ('package_file', common.utils.fields.DatabaseFileField(null=True, verbose_name='\u0424\u0430\u0439\u043b \u043f\u0430\u043a\u0435\u0442\u0430', blank=True)),
                ('autoimport', models.BooleanField(default=False, verbose_name='\u0410\u0432\u0442\u043e\u0438\u043c\u043f\u043e\u0440\u0442')),
                ('every_day_autoimport', models.BooleanField(default=False, help_text='\u0415\u0436\u0435\u0434\u043d\u0435\u0432\u043d\u044b\u0439 \u0430\u0432\u0442\u043e\u0438\u043c\u043f\u043e\u0440\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0442\u043e\u0433\u0434\u0430, \u043a\u043e\u0433\u0434\u0430 \u0432\u043a\u043b\u044e\u0447\u0435\u043d \u043e\u0431\u044b\u0447\u043d\u044b\u0439 \u0430\u0432\u0442\u043e\u0438\u043c\u043f\u043e\u0440\u0442', verbose_name='\u0415\u0436\u0435\u0434\u043d\u0435\u0432\u043d\u044b\u0439 \u0410\u0432\u0442\u043e\u0438\u043c\u043f\u043e\u0440\u0442', editable=False)),
                ('comment', models.TextField(null=True, verbose_name='\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435', blank=True)),
                ('create_stations', models.BooleanField(default=False, help_text='\u0414\u043b\u044f \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0445 \u043d\u0443\u0436\u0434', verbose_name='\u0421\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438')),
                ('url', common.utils.fields.CodeCharField(default=None, max_length=255, null=True, verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430 \u0434\u043b\u044f \u0441\u043a\u0430\u0447\u0438\u0432\u0430\u043d\u0438\u044f', blank=True)),
                ('username', common.utils.fields.CodeCharField(default=None, max_length=255, null=True, verbose_name='\u0418\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f', blank=True)),
                ('password', common.utils.fields.CodeCharField(default=None, max_length=255, null=True, verbose_name='\u041f\u0430\u0440\u043e\u043b\u044c', blank=True)),
                ('last_import_date', models.DateField(null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430', blank=True)),
                ('last_mask_date', models.DateField(null=True, verbose_name='\u0414\u0430\u0442\u0430, \u043f\u043e\u0441\u043b\u0435 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0432\u0441\u0435 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u0438 \u043d\u0438\u0442\u043e\u043a \u0431\u0443\u0434\u0443\u0442 \u043f\u0443\u0441\u0442\u044b\u043c\u0438', blank=True)),
                ('notify_content_manager', models.BooleanField(default=False, verbose_name='\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u044f\u0442\u044c \u043a\u043e\u043d\u0442\u0435\u043d\u0442-\u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u0430')),
                ('supplier_email', models.EmailField(max_length=254, null=True, verbose_name='E-mail \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430', blank=True)),
                ('notify_supplier', models.BooleanField(default=False, verbose_name='\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u044f\u0442\u044c \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430')),
                ('encoding', models.CharField(default=None, choices=[(b'utf-8', b'utf-8'), (b'cp1251', b'cp1251')], max_length=20, blank=True, null=True, verbose_name='\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430')),
                ('package_type', models.CharField(default=b'cysix', max_length=30, verbose_name='\u0422\u0438\u043f \u043f\u0430\u043a\u0435\u0442\u0430', choices=[(b'cysix', '\u043e\u0431\u0449\u0438\u0439 xml'), (b'triangle', '\u0442\u0440\u0435\u0443\u0433\u043e\u043b\u044c\u043d\u044b\u0439'), (b'special', '\u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0439')])),
                ('allow_back_pseudo_routes', models.BooleanField(default=False, verbose_name='\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u0435 \u043e\u0431\u0440\u0430\u0442\u043d\u044b\u0445 \u043f\u0441\u0435\u0432\u0434\u043e\u0440\u0435\u0439\u0441\u043e\u0432')),
                ('content_manager', models.ForeignKey(default=None, verbose_name='\u041e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0439 \u043a\u043e\u043d\u0442\u0435\u043d\u0442-\u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440', to='importinfo.ContentManager', null=True)),
                ('country', models.ForeignKey(verbose_name='\u0421\u0442\u0440\u0430\u043d\u0430', blank=True, to='www.Country', null=True)),
                ('currency', models.ForeignKey(verbose_name='\u0412\u0430\u043b\u044e\u0442\u0430', blank=True, to='currency.Currency', null=True)),
                ('region', models.ForeignKey(verbose_name='\u0420\u0435\u0433\u0438\u043e\u043d', blank=True, to='www.Region', null=True)),
                ('settlement', models.ForeignKey(verbose_name='\u0413\u043e\u0440\u043e\u0434', blank=True, to='www.Settlement', null=True)),
                ('supplier', models.ForeignKey(verbose_name='\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a', to='www.Supplier')),
                ('t_type', models.ForeignKey(default=3, verbose_name='\u0422\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType')),
            ],
            options={
                'db_table': 'importinfo_twostagebusimportpackage',
                'verbose_name': '\u0414\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u041f\u0430\u043a\u0435\u0442',
                'verbose_name_plural': '\u0414\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u041f\u0430\u043a\u0435\u0442\u044b',
            },
        ),
        migrations.CreateModel(
            name='TwoStageImportStation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', common.utils.fields.TrimmedCharField(default='', max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0432\u0438\u044f', blank=True)),
                ('real_title', common.utils.fields.TrimmedCharField(default='', max_length=255, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043f\u0440\u0438 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u043c \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', blank=True)),
                ('geocode_title', common.utils.fields.TrimmedCharField(default='', max_length=255, null=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u0434\u043b\u044f \u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f', blank=True)),
                ('additional_info', models.TextField(default=None, null=True, verbose_name='\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f', blank=True)),
                ('code', common.utils.fields.TrimmedCharField(default='', max_length=255, verbose_name='\u041a\u043e\u0434 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', blank=True)),
                ('longitude', models.FloatField(default=None, null=True, verbose_name='\u0434\u043e\u043b\u0433\u043e\u0442\u0430', blank=True)),
                ('latitude', models.FloatField(default=None, null=True, verbose_name='\u0448\u0438\u0440\u043e\u0442\u0430', blank=True)),
                ('package', models.ForeignKey(to='importinfo.TwoStageImportPackage')),
                ('station_mapping', models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, verbose_name='\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0439', to='importinfo.StationMapping', help_text='\u0442\u043e\u0447\u043d\u043e\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435, \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u043f\u0440\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0435 \u0432 \u043f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043e\u0447\u043d\u0443\u044e \u0431\u0430\u0437\u0443', null=True)),
            ],
            options={
                'db_table': 'importinfo_twostagebusimportstation',
                'verbose_name': '\u0434\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u0421\u0442\u0430\u043d\u0446\u0438\u044f',
                'verbose_name_plural': '\u0434\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u0421\u0442\u0430\u043d\u0446\u0438\u0438',
            },
        ),
        migrations.CreateModel(
            name='TwoStageImportThread',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('path_key', models.TextField(default=None, null=True, verbose_name='\u041a\u043b\u044e\u0447 \u043f\u0443\u0442\u0438', blank=True)),
                ('package', models.ForeignKey(related_name='threads', to='importinfo.TwoStageImportPackage')),
            ],
            options={
                'db_table': 'importinfo_twostagebusimportthread',
                'verbose_name': '\u0434\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u041d\u0438\u0442\u043a\u0430',
                'verbose_name_plural': '\u0434\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u041d\u0438\u0442\u043a\u0438',
            },
            bases=(models.Model, travel.rasp.admin.www.models.geo.RoutePathOwner),
        ),
        migrations.CreateModel(
            name='TwoStageImportThreadStation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('station', models.ForeignKey(related_name='threadstations', to='importinfo.TwoStageImportStation')),
                ('thread', models.ForeignKey(related_name='threadstations', to='importinfo.TwoStageImportThread')),
            ],
            options={
                'ordering': ('id',),
                'db_table': 'importinfo_twostagebusimportthreadstation',
                'verbose_name': '\u0434\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u0421\u0442\u0430\u043d\u0446\u0438\u044f \u043d\u0438\u0442\u043a\u0438',
                'verbose_name_plural': '\u0434\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u043d\u044b\u0439 \u0438\u043c\u043f\u043e\u0440\u0442: \u0421\u0442\u0430\u043d\u0446\u0438\u0438 \u043d\u0438\u0442\u043e\u043a',
            },
        ),
        migrations.CreateModel(
            name='YaCalendarXml',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('year', models.IntegerField(verbose_name='\u0413\u043e\u0434', choices=[(2014, 2014), (2015, 2015), (2016, 2016), (2017, 2017), (2018, 2018)])),
                ('xml_file', common.utils.fields.DatabaseFileField(verbose_name='\u0424\u0430\u0439\u043b \u043f\u0430\u043a\u0435\u0442\u0430', validators=[travel.rasp.admin.importinfo.models.validators.is_xml_validator])),
                ('country', models.ForeignKey(verbose_name='\u0421\u0442\u0440\u0430\u043d\u0430', to='www.Country')),
            ],
            options={
                'ordering': ('country', '-year'),
                'verbose_name': '\u042d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u043a\u0438: \u041a\u043e\u043f\u0438\u044f \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044f',
                'verbose_name_plural': '\u042d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u043a\u0438: \u041a\u043e\u043f\u0438\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044f',
            },
        ),
        migrations.AddField(
            model_name='tsithreadstationflag',
            name='package',
            field=models.ForeignKey(related_name='thread_station_flags', to='importinfo.TwoStageImportPackage'),
        ),
        migrations.AddField(
            model_name='tsithreadsetting',
            name='package',
            field=models.ForeignKey(related_name='tsi_thread_settings', to='importinfo.TwoStageImportPackage'),
        ),
        migrations.AddField(
            model_name='tsisetting',
            name='package',
            field=models.OneToOneField(to='importinfo.TwoStageImportPackage'),
        ),
        migrations.AddField(
            model_name='trianglebusimportpackage',
            name='tsi_package',
            field=models.OneToOneField(null=True, default=None, to='importinfo.TwoStageImportPackage', blank=True, verbose_name='\u0414\u0432\u0443\u0445\u0441\u0442\u0443\u043f\u0435\u043d\u0447\u0430\u0442\u044b\u0439 \u043f\u0430\u043a\u0435\u0442'),
        ),
        migrations.AddField(
            model_name='packagedirectionsslice',
            name='package',
            field=models.ForeignKey(to='importinfo.TwoStageImportPackage'),
        ),
        migrations.AddField(
            model_name='originalthreaddata',
            name='package',
            field=models.ForeignKey(default=None, editable=False, to='importinfo.TwoStageImportPackage', null=True),
        ),
        migrations.AddField(
            model_name='originalthreaddata',
            name='supplier',
            field=models.ForeignKey(default=None, editable=False, to='www.Supplier', null=True),
        ),
        migrations.AddField(
            model_name='originalthreaddata',
            name='thread',
            field=models.ForeignKey(default=None, blank=True, editable=False, to='www.RThread', null=True),
        ),
        migrations.AddField(
            model_name='directionslice',
            name='package_slice',
            field=models.ForeignKey(to='importinfo.PackageDirectionsSlice'),
        ),
        migrations.AddField(
            model_name='cysixgroupfilter',
            name='package',
            field=models.ForeignKey(to='importinfo.TwoStageImportPackage'),
        ),
        migrations.AlterUniqueTogether(
            name='yacalendarxml',
            unique_together=set([('country', 'year')]),
        ),
        migrations.AlterUniqueTogether(
            name='twostageimportstation',
            unique_together=set([('title', 'code', 'package')]),
        ),
        migrations.AlterUniqueTogether(
            name='tabloimportsynonym',
            unique_together=set([('title', 'supplier')]),
        ),
        migrations.AlterUniqueTogether(
            name='route2terminal',
            unique_together=set([('number', 'terminal')]),
        ),
        migrations.AlterUniqueTogether(
            name='relatedlog',
            unique_together=set([('object_id', 'content_type', 'tag'), ('code', 'tag')]),
        ),
        migrations.AlterUniqueTogether(
            name='mtasettlementmapping',
            unique_together=set([('area_code', 'stop_city')]),
        ),
        migrations.AlterUniqueTogether(
            name='cysixgroupfilter',
            unique_together=set([('code', 'package')]),
        ),
        migrations.AlterUniqueTogether(
            name='companysynonym',
            unique_together=set([('title', 't_type')]),
        ),
        migrations.AlterUniqueTogether(
            name='buscomuastationcode',
            unique_together=set([('server_code', 'city_code', 'station_code', 'station')]),
        ),
    ]
