# -*- coding: utf-8 -*-

from django.db import models
from django.utils.translation import ugettext_lazy as _


class ContentManager(models.Model):
    """
    Справочник "Контент-Менеджеры"

    Нужен для того, чтобы в пакеты импортов прописывать ответственного контент менеджера,
    и иметь возможность отфильтровать/упорядочить пакеты по контент менеджеру.

    Табличка User не подходит, т.к. большинство контент менеджеров не имеют до нее доступа.
    """

    name = models.CharField(_(u'Имя'), max_length=30, unique=True, blank=False, null=True)
    email = models.EmailField(_(u'e-mail адрес'), blank=False)

    class Meta:
        app_label = 'importinfo'
        verbose_name = _(u'Контент менеджер')
        verbose_name_plural = _(u'Справочник "Контент-Менеджеры"')

    def __unicode__(self):
        return u'{name} <{email}>'.format(name=self.name, email=self.email)
