# -*- coding: utf-8 -*-

from django.db import models
from django.utils.translation import ugettext_lazy as _
from common.utils.fields import TrimmedCharField


class EtrafficMainBusStationInGroup(models.Model):
    group_code = TrimmedCharField(
        verbose_name=_(u'Код группы'), max_length=255, null=False, blank=False, unique=True,
        help_text=_(u'Нужно заполнить как указано в данных поставщика')
    )
    code = TrimmedCharField(
        verbose_name=_(u'Код главного автовокзала группы'), max_length=255, null=False, blank=False,
        help_text=_(u'Нужно заполнить как указано в данных поставщика')
    )
    title = TrimmedCharField(
        verbose_name=_(u'Название главного автовокзала группы'), max_length=255, null=False, blank=False,
        help_text=_(u'Нужно заполнить как указано в данных поставщика')
    )
    ACTION_CHOICES = (
        ('skip', _(u'Пропускать нитку')),
        ('add_first', _(u'Добавить главный автовокзал первой остановкой в нитку')),
    )
    action_on_thread_without_main_station = models.CharField(
        verbose_name=_(u'Что делать, если в нитке нет главного автовокзала группы'),
        max_length=10, choices=ACTION_CHOICES, default='skip', blank=False, null=False,
        help_text=_(u'Выставляйте значение "Добавить главный автовокзал первой остановкой в нитку" '
                    u'только, если код и название главного автовокзала заполненны правильно.')
    )

    class Meta:
        app_label = 'importinfo'
        verbose_name = _(u'E-traffic: Главный автовокзал группы')
        verbose_name_plural = _(u'E-traffic: Главные автовокзалы группы')
