# coding: utf-8

# Deprecated
# Лучше использовать. Express2Country

import re

from common.importinfo.models import Express2Country

from common.utils.caching import cache_until_switch


_e2c_regex_cache = None
_module_cache_built = False


def precache():
    global _e2c_regex_cache, _module_cache_built

    _e2c_regex_cache = _get_all()

    _module_cache_built = True


@cache_until_switch
def get_tz_by_express(express_code):
    e2c = _get_e2c_by_express(express_code)

    if e2c:
        if e2c.time_zone:
            return e2c.time_zone

        else:
            return e2c.country.get_capital_tz()

    return None


@cache_until_switch
def get_country_by_express(express_code):
    e2c = _get_e2c_by_express(express_code)

    if e2c:
        return e2c.country

    return None


@cache_until_switch
def _get_e2c_by_express(express_code):
    regex_records = _get_all()

    for regex, e2c in regex_records:
        if regex.match(express_code):
            return e2c

    return None


def _get_all():
    if _module_cache_built:
        return _e2c_regex_cache

    return _get_all_from_db()


@cache_until_switch
def _get_all_from_db():
    regex_records = []

    for e2c in Express2Country.objects.all():
        regex = re.compile(e2c.code_re, flags=re.U)

        regex_records.append((regex, e2c))

    return regex_records
