# -*- coding: utf-8 -*-

import json

from django.db import models
from django.utils.translation import ugettext_lazy as _


class IpekturStopsOrder(models.Model):
    original_order = models.TextField(_(u'Порядок остановок в данных от ipektur'),
                                      null=False, blank=False)
    right_order = models.TextField(_(u'Правильный порядок остановок'),
                                   null=False, blank=True, default='')
    use = models.BooleanField(_(u'Использовать'), default=False,
                              help_text=_(u'Использовать замену порядка следования остановок'))

    class Meta:
        app_label = 'importinfo'
        verbose_name = _(u'Ipektur: Порядок следования остановок')
        verbose_name_plural = _(u'Ipektur: Порядок следования остановок')

    @classmethod
    def get_substitutions_dict(cls):
        substitutions = dict()

        stops_orders = cls.objects.filter(use=True).exclude(right_order__exact='')

        # если ключ встречается два раза, то не используем его
        bad_keys = set()

        for so in stops_orders:
            try:
                key = tuple(json.loads(so.original_order))

                if key in substitutions:
                    bad_keys.add(key)

                value = json.loads(so.right_order)

                substitutions[key] = value

            except ValueError:
                pass

        for key in bad_keys:
            del substitutions[key]

        return substitutions
