# -*- coding: utf-8 -*-

from django.db import models
from django.utils.translation import ugettext_lazy as _


class AirportForAgentImport(models.Model):
    station = models.ForeignKey('www.Station', verbose_name=_(u'Аэропорт'), null=False, blank=False)
    FREQUENCY_CHOICES = (
        ('1h', _(u'1 час')),
        ('10min', _(u'10 минут')),
    )
    update_frequency = models.CharField(_(u'Обновлять раз в'), max_length=10, choices=FREQUENCY_CHOICES,
                                        default='1h', blank=False, null=False)

    @property
    def settlement(self):
        return self.station.settlement

    @property
    def code(self):
        if not self.settlement:
            return None

        return self.settlement.iata or self.settlement.sirena_id

    class Meta:
        app_label = 'importinfo'
        verbose_name = _(u'Аэропорт для импорта табло от Агента')
        verbose_name_plural = _(u'Список аэропортов для импорта табло от Агента')
