# coding: utf-8

from django.db import models
from django.utils.translation import ugettext_lazy as _


class TrustedStation(models.Model):
    station = models.OneToOneField('www.Station', limit_choices_to={'is_base': True},
                                   verbose_name=_(u'Опорный автовокзал'),
                                   help_text=_(u'Должен быть базовым (галка в таблице Station)'))
    tsi_package = models.ForeignKey('importinfo.TwoStageImportPackage',
                                    verbose_name=_(u'Двухступенчатый пакет'))
    tsi_package_group = models.ForeignKey('importinfo.CysixGroupFilter',
                                          null=True, blank=True, default=None,
                                          verbose_name=_(u'Группа пакета'),
                                          help_text=_(u'Чтобы получить группы выбранного пакета, нажмите кнопку '
                                                      u'Сохранить и продолжить редактирование'))

    class Meta:
        app_label = 'importinfo'
        verbose_name = _(u'Опорный автовокзал')
        verbose_name_plural = _(u'Опорные автовокзалы')
