# -*- coding: utf-8 -*-

from django.core.exceptions import ValidationError
from lxml import etree

from travel.rasp.admin.lib.exceptions import UnpackError
from travel.rasp.admin.lib.tmpfiles import temp_manager, clean_temp
from travel.rasp.admin.lib.unzip import unpack_zip_file


@clean_temp
def triangle_file_validator(fileobj):
    from travel.rasp.admin.importinfo.models.bus import TriangleBusImportPackage

    tmp_dir = temp_manager.get_tmp_dir('importinfo/triangle_import')

    try:
        file_map = unpack_zip_file(fileobj, tmp_dir)

        if not has_required_files(file_map.keys()):
            raise ValidationError(u"Архив не содержит необходимых файлов %s" %
                                  u", ".join(rf + u"." + u"|".join(TriangleBusImportPackage.FILE_FORMATS)
                                             for rf in TriangleBusImportPackage.REQUIRED_FILE_NAMES))

    except UnpackError, e:
        raise ValidationError(u"Фаил не является архивом или содержит плохие данные: %s" % unicode(e))

    finally:
        fileobj.seek(0)


def has_required_files(filenames):
    from travel.rasp.admin.importinfo.models.bus import TriangleBusImportPackage

    for required_filename in TriangleBusImportPackage.REQUIRED_FILE_NAMES:
        has_file = False
        for filename in filenames:
            if '.' in filename:
                name, ext = filename.split('.', 1)
                if name == required_filename and ext in TriangleBusImportPackage.FILE_FORMATS:
                    has_file = True

        if not has_file:
            return False

    return True


def is_xml_validator(fileobj):
    try:
        etree.parse(fileobj)
    except Exception, e:
        raise ValidationError(u"Файл не является xml: %s" % unicode(e))
    finally:
        fileobj.seek(0)
