# -*- coding: utf-8 -*-

from functools import wraps

from django.db import transaction

from travel.rasp.admin.importinfo.models import RelatedLog
from travel.rasp.admin.lib.logs import get_collector, remove_collector


@transaction.atomic
def update_log(obj, tag, logged):
    related_log = RelatedLog.get_by_object(obj, tag)
    if not related_log:
        related_log = RelatedLog.create_from_object(obj, tag)

    related_log.log = logged
    related_log.save()


@transaction.atomic
def update_logs(obj, tag, logged_by_lang):
    if not logged_by_lang:
        return

    related_log = RelatedLog.get_by_object(obj, tag)
    if not related_log:
        related_log = RelatedLog.create_from_object(obj, tag)

    for lang, logged in logged_by_lang.iteritems():
        setattr(related_log, 'log_%s' % lang, logged or '')

    related_log.save()


def save_log_for_first_arg_object(tag=None, is_method=False):
    first_arg = tag

    if callable(first_arg):
        tag = None

    def decorator(func):
        wraps(func)

        def wrapper(*args, **kwargs):
            if is_method:
                obj = args[1]
            else:
                obj = args[0]

            collector = get_collector('')

            try:
                return func(*args, **kwargs)
            finally:
                logged = collector.get_collected()
                update_log(obj, tag, logged)

                remove_collector('', collector)

        return wrapper

    if callable(first_arg):
        return decorator(first_arg)
    else:
        return decorator
