# -*- coding: utf-8 -*-

from common.utils.date import RunMask
from travel.rasp.library.python.common23.date import environment


def get_threads_last_mask_date(thread_queryset, today=None):
    """
    Возвращает последнюю дату старта ниток, возможно в прошлом, или None.
    """

    today = today or environment.today()

    joined_mask = RunMask(today=today)

    for thread_year_days in thread_queryset.values_list('year_days', flat=True):
        joined_mask |= RunMask(thread_year_days)

    try:
        return max(joined_mask.iter_dates())

    except ValueError:
        return None


def get_threads_last_mask_date_and_starts_quantity(thread_queryset, today=None):
    """
    Возвращает последнюю дату старта нитки, начиная с today, и
    количество стартов, начиная с today, или None, None.
    """

    today = today or environment.today()

    run_masks = [RunMask(year_days, today=today)
                 for year_days in thread_queryset.values_list('year_days', flat=True)]

    run_dates = reduce(lambda a, b: a | b, run_masks, RunMask(today=today)).dates(past=False)

    if not run_dates:
        return None, None

    starts_quantity = sum(len(m.dates(past=False)) for m in run_masks)

    return max(run_dates), starts_quantity
