# coding: utf-8

from urllib import quote
from django.conf import settings
from django.contrib.auth import REDIRECT_FIELD_NAME
from django.contrib.auth.decorators import user_passes_test


def get_rasp_admin_url(object, relative_only=False):
    relative_url = u"/admin/%(app_label)s/%(module_name)s/%(object_id)s/" % {
        'app_label': object._meta.app_label,
        'module_name': object._meta.model_name,
        'object_id': quote(unicode(object.pk).encode('utf8'))
    }
    if relative_only:
        return relative_url
    else:
        return (u"https://%s" % (settings.ADMIN_DOMAIN_NAME or settings.DOMAIN_NAME)) + relative_url


def superuser_required(view_func, redirect_field_name=REDIRECT_FIELD_NAME, login_url='admin:login'):
    """
    Decorator for views that checks that the user is logged in and is a staff
    member, displaying the login page if necessary.
    """
    return user_passes_test(
        lambda u: u.is_active and u.is_staff and u.is_superuser,
        login_url=login_url,
        redirect_field_name=redirect_field_name
    )(view_func)
