# coding: utf-8

from __future__ import unicode_literals

import logging
import subprocess

from travel.rasp.admin.lib.exceptions import SimpleUnicodeException

log = logging.getLogger(__name__)

INDEX_FILE_NAME = '__index__.html'


class DownloadFilesError(SimpleUnicodeException):
    pass


def get_wget_options(path, cut_dirs):
    wget_options = [
        '--recursive', '--no-host-directories', '--no-parent', '--quiet'
    ]
    wget_options.extend(map(lambda (k, v): '{}={}'.format(k, v), [
        ('--default-page', INDEX_FILE_NAME),
        ('--directory-prefix', path),
        ('--level', '10'),
        ('--output-file', '/dev/stdout'),
        ('--cut-dirs', str(cut_dirs))
    ]))
    return wget_options


def download_files(url, path, cut_dirs):
    log.info('Выкачиваем файлы из %s', url)

    wget_args = ['wget', url] + get_wget_options(path, cut_dirs)

    process = subprocess.Popen(wget_args, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    wget_stdout = process.stdout.read()
    wget_stderr = process.stderr.read()
    if wget_stdout:
        log.info('Wget stdout:\n%s', wget_stdout)
    if wget_stderr:
        log.info('Wget stderr:\n%s', wget_stderr)
    if process.wait():
        raise DownloadFilesError('Ошибка выкачивания файлов')

    subprocess.call(['find', path, '-name', INDEX_FILE_NAME, '-delete'])
    log.info('Успешно выкачали файлы')
