# -*- coding: utf-8 -*-

from chardet.universaldetector import UniversalDetector


transform_to_usual_values = {
    'windows-1251': 'cp1251',
}


def detect_file_encoding_by_path(filepath, any_confidence=False):
    detector = UniversalDetector()

    detector.feed(open(filepath, 'rb').read())

    detector.close()

    if not any_confidence and detector.result['confidence'] < 0.5:
        return None

    return transform_to_usual_values.get(detector.result['encoding'], detector.result['encoding'])
