# -*- coding: utf-8 -*-

import logging
import socket
from httplib import HTTPConnection
from urllib2 import HTTPHandler


log = logging.getLogger(__name__)


def set_keepalive_linux(sock, after_idle_sec=60, interval_sec=60, max_fails=15):
    """Set TCP keepalive on an open socket.

    It activates after 1 second (after_idle_sec) of idleness,
    then sends a keepalive ping once every 3 seconds (interval_sec),
    and closes the connection after 5 failed ping (max_fails), or 15 seconds
    """

    sock.setsockopt(socket.SOL_SOCKET, socket.SO_KEEPALIVE, 1)
    sock.setsockopt(socket.IPPROTO_TCP, socket.TCP_KEEPIDLE, after_idle_sec)
    sock.setsockopt(socket.IPPROTO_TCP, socket.TCP_KEEPINTVL, interval_sec)
    sock.setsockopt(socket.IPPROTO_TCP, socket.TCP_KEEPCNT, max_fails)


# Для поддержки Серёжиных скриптов
def get_http_timeout_handler_class(timeout):
    class TimeoutConnection(HTTPConnection):
        def connect(self):
            """Connect to the host and port specified in __init__."""
            msg = "getaddrinfo returns an empty list"

            # raise Exception((self.host, self.port))

            for res in socket.getaddrinfo(self.host, self.port, 0,
                                          socket.SOCK_STREAM):

                af, socktype, proto, canonname, sa = res
                try:
                    self.sock = socket.socket(af, socktype, proto)
                    self.sock.settimeout(timeout)
                    set_keepalive_linux(self.sock)
                    if self.debuglevel > 0:
                        print "connect: (%s, %s)" % (self.host, self.port)
                    self.sock.connect(sa)
                except socket.error, msg:
                    if self.debuglevel > 0:
                        print 'connect fail:', (self.host, self.port)
                    if self.sock:
                        self.sock.close()
                    self.sock = None
                    continue
                break

            if not self.sock:
                raise socket.error, msg

    class TimeoutHandler(HTTPHandler):
        def http_open(self, req):
            return self.do_open(TimeoutConnection, req)

    return TimeoutHandler
