# -*- coding: utf-8 -*-
import StringIO

try:
    from PIL import Image
except ImportError:
    import Image

from wand import image, color
from wand.api import library


def svg2image(svg, size):
    """
    :param svg: binary data
    :param size: tuple (width, height)
    :return: PIL.Image.Image
    """
    with image.Image() as img:
        with color.Color('transparent') as bg_color:
            library.MagickSetBackgroundColor(img.wand, bg_color.resource)
            img.read(blob=svg)
            width, height = inscribed_size((img.width, img.height), size)
            img.resize(width, height)
            return Image.open(StringIO.StringIO(img.make_blob('png')))


def inscribed_size(src, dst):
    src_x, src_y = src
    dst_x, dst_y = dst
    scale = min(float(dst_x) / src_x, float(dst_y) / src_y)

    return (int(src_x * scale), int(src_y * scale))


def get_pilimage_content(img, fmt='PNG'):
    out = StringIO.StringIO()
    img.save(out, fmt)
    content = out.getvalue()
    out.close()

    return content
