# -*- coding: utf-8 -*-

import fcntl
from contextlib import contextmanager


@contextmanager
def acquire_exclusive_lock(filename):
    with open(filename, mode='w') as fp:
        fcntl.flock(fp.fileno(), fcntl.LOCK_EX)
        yield
        fcntl.flock(fp.fileno(), fcntl.LOCK_UN)
