# coding: utf-8

import logging
import sys
import os
from subprocess import check_output, CalledProcessError

from django.conf import settings


log = logging.getLogger(__name__)


def run_migrations(check_flag=True):
    try:
        process_env = os.environ.copy()
        process_env.update({'Y_PYTHON_ENTRY_POINT': 'travel.rasp.admin.app:manage'})
        command_parts = [sys.executable, 'update', '--verbosity=1']
        if not check_flag:
            command_parts.append('--ignore-flag')
        output = check_output(command_parts, env=process_env, cwd=settings.PROJECT_PATH, close_fds=True)
        log.info(output.decode('utf8'))
    except CalledProcessError, e:
        log.error(e.output.decode('utf8'))
        raise
