# coding: utf-8

import logging

from django.conf import settings

from common.db.switcher import instance_role_alias
from travel.rasp.admin.lib.exceptions import SimpleUnicodeException
from travel.rasp.admin.lib.maintenance.db_update import run_migrations
from travel.rasp.admin.lib.maintenance.flags import flags, job, get_flag_note


log = logging.getLogger(__name__)


class DeployException(SimpleUnicodeException):
    pass


def finalize_deploy():
    if flags['maintenance'] != job.DEPLOY.flag_value:
        log.info(
            u'Завершение выкладки пакета возможно полько при поднятом флаге {}. Сейчас установлен флаг {} -- {}. '
            u'Должен быть {}. Текущая база {}'.format(
                job.DEPLOY.verbose_name, flags['maintenance'], get_flag_note('maintenance'),
                job.DEPLOY.flag_value, instance_role_alias())
        )

        return

    if settings.INSTANCE_ROLE.code == 'service':
        log.info(u'Запускаем миграции')
        try:
            _run_migrations_without_flag_check()
            log.info(u'Миграции прошли успешно')
        except Exception:
            raise DeployException(u'Произошла ошибка при выполнении миграции')

    flags['maintenance'] = 0
    log.info(u'Сняли флаг')


def _run_migrations_without_flag_check():
    run_migrations(check_flag=False)
