# coding: utf-8

from __future__ import unicode_literals

from common.utils.date import RunMask
from travel.rasp.admin.lib.exceptions import SimpleUnicodeException
from travel.rasp.admin.lib.mask_builder.standard_builders import daily_mask, even_mask, odd_mask, empty_mask, mask_from_days_of_week
from travel.rasp.admin.lib.mask_builder.ycal_builders import ycal_weekends_and_holidays_mask, ycal_holidays_mask
from travel.rasp.admin.lib.mask_builder.ycal_builders import ycal_workdays_mask
from travel.rasp.admin.scripts.schedule.utils.afmasktext import get_af_texts, get_af_matcher, AFTextMatchError


class AfMaskBuilder(object):
    def __init__(self):
        self.af_mask_texts = {mt.code: mt for mt in get_af_texts()}
        self.mask_codes = tuple(self.af_mask_texts.keys())
        self.text_matcher = get_af_matcher(self.mask_codes)

    def is_af_mask_text(self, text):
        if not text.strip():
            return False

        try:
            self.text_matcher.find_compound_match(text)
            return True
        except AFTextMatchError:
            return False

    def build(self, bounds, text, country=None, today=None):
        # C это отмена, русская или английская C
        if text in 'CС':
            return RunMask(today=today)

        positive_matches, negative_matches = self.text_matcher.find_compound_match(text)

        mask = empty_mask(today)
        if not positive_matches and negative_matches:
            mask = daily_mask(bounds, today)

        for match in positive_matches + negative_matches:
            af_mask = match.mask

            new_mask = empty_mask(today)

            if af_mask.digits:
                new_mask |= mask_from_days_of_week(bounds, ''.join(af_mask.digits), today)

            if af_mask.letters:
                for letter in af_mask.letters:
                    new_mask |= self._mask_from_letter(letter, bounds, country, today)

            if af_mask.negative:
                mask -= new_mask
            else:
                mask |= new_mask

        return mask

    def _mask_from_letter(self, letter, bounds, country, today):
        if letter == 'D':
            return daily_mask(bounds, today)
        elif letter == 'E':
            return even_mask(bounds, today)
        elif letter == 'U':
            return odd_mask(bounds, today)
        elif letter == 'H':
            return ycal_weekends_and_holidays_mask(bounds, country, today)
        elif letter == 'W':
            return ycal_workdays_mask(bounds, country, today)
        elif letter == 'F':
            return ycal_holidays_mask(bounds, country, today)

        raise SimpleUnicodeException('Не нашли метод для буквы "{}"'.format(letter))
