# coding: utf-8

from __future__ import unicode_literals

from django.conf import settings
from django.utils.encoding import force_text
from pathlib2 import Path


# используется для пересадочника (pathfinder)
def write_conf(conf):
    path = Path(settings.CONF_FILE)
    path.parent.mkdir(parents=True, exist_ok=True)
    with path.open('wb') as f:
        for name, value in conf.items():
            f.write('{} {}\n'.format(force_text(name), force_text(value)))
