# coding: utf-8

from __future__ import unicode_literals


def table_exists(schema_editor, table):
    with schema_editor.connection.cursor() as cursor:
        query = '''
        SELECT *
        FROM information_schema.TABLES
        WHERE
            TABLE_SCHEMA = DATABASE()
            AND TABLE_NAME = %s
        '''

        cursor.execute(query, [table])
        return len(cursor.fetchall()) == 1


def field_exists(schema_editor, table, field):
    with schema_editor.connection.cursor() as cursor:
        query = '''
        SELECT *
        FROM information_schema.COLUMNS
        WHERE
            TABLE_SCHEMA = DATABASE()
            AND TABLE_NAME = %s
            AND COLUMN_NAME = %s
        '''

        cursor.execute(query, [table, field])
        return len(cursor.fetchall()) == 1


def drop_field(schema_editor, table, field):
    query = schema_editor.sql_delete_column % {
        "table": schema_editor.quote_name(table),
        "column": schema_editor.quote_name(field),
    }

    with schema_editor.connection.cursor() as cursor:
        cursor.execute(query)


def drop_table(schema_editor, table):
    query = schema_editor.sql_delete_table % {
        "table": schema_editor.quote_name(table)
    }

    with schema_editor.connection.cursor() as cursor:
        cursor.execute(query)


def drop_field_if_exists(schema_editor, table, field):
    """
    :return: Была удалена колонка или нет.
    """
    if field_exists(schema_editor, table, field):
        drop_field(schema_editor, table, field)
        return True
    else:
        return False


def drop_table_if_exists(schema_editor, table):
    """
    :return: Была удалена таблица или нет.
    """
    if table_exists(schema_editor, table):
        drop_table(schema_editor, table)
        return True
    else:
        return False
