# -*- coding: utf-8 -*-

from django.db import connection, transaction


@transaction.atomic
def fast_delete(qs):
    """Быстро удаляет queryset без зависимостей"""

    sql, params = qs.order_by().query.get_compiler(connection=connection).as_sql()

    # Мегахак
    del_sql = (
        'DELETE %s ' % connection.ops.quote_name(qs.model._meta.db_table)
    ) + sql[sql.index('FROM'):]

    cursor = connection.cursor()

    cursor.execute(del_sql, params)


