# source http://en.wikipedia.org/wiki/Dash

HYPHENS = [u'\u2010', u'\u00AD', u'\u2011', u'\u2043']
DASHES = [u'\u2012', u'\u2013', u'\u2014', u'\u2015']


def unify_minuses(text):
    replace_with = u"-"

    for h in HYPHENS:
        if h in text:
            text = text.replace(h, replace_with)

    for d in DASHES:
        if d in text:
            text = text.replace(d, replace_with)

    return text
