# -*- coding: utf-8 -*-


class CaseInsensitiveSet():
    def __init__(self):
        self._s = set()

    def _lower(self, value):
        try:
            value = tuple([v.lower() for v in value])

        except TypeError:
            value = value.lover()

        return value

    def add(self, value):
        self._s.add(self._lower(value))

    def __contains__(self, item):
        return self._s.__contains__(self._lower(item))

