# -*- coding: utf-8 -*-

from functools import wraps

from django.conf import settings
from travel.rasp.admin.lib.tmpfiles import get_tmp_dir, clean_temp


def use_tmp_data_path(func):
    @wraps(func)
    @clean_temp
    def wrapper(*args, **kwargs):
        old_data_dir = settings.DATA_PATH
        tmp_data_dir = get_tmp_dir('tests')

        settings.DATA_PATH = tmp_data_dir

        try:
            func(*args, **kwargs)
        finally:
            settings.DATA_PATH = old_data_dir

    return wrapper
