# -*- coding: utf-8 -*-

import os
from subprocess import call

from travel.rasp.admin.lib.exceptions import UnpackError
from travel.rasp.admin.lib.fileutils import remove_tmp_dir, get_relative_path
from travel.rasp.admin.lib.tmpfiles import get_tmp_dir


def unpack_rar_file(fileobj, temporary_directory=None):
    is_string = False
    if isinstance(fileobj, basestring):
        fileobj = open(fileobj)
        is_string = True

    try:

        if not temporary_directory:
            temporary_directory = get_tmp_dir('lib/unrar/')

        remove_tmp_dir(temporary_directory)

        os.makedirs(temporary_directory)

        rar_file = os.path.join(temporary_directory, 'file.rar')

        with open(rar_file, 'wb') as f:
            f.write(fileobj.read())

        success = call(['unrar', 'x', '-o+', '-y', '-inul', '-r', rar_file, temporary_directory]) == 0

        if not success:
            raise UnpackError(u"Ошибка распаковки rar файла")

        os.remove(rar_file)

        file_map = {}
        for dirpath, dirnames, filenames in os.walk(temporary_directory):
            for filename in filenames:
                filepath = os.path.normpath(os.path.abspath(os.path.join(dirpath, filename)))

                map_name = get_relative_path(filepath, temporary_directory)

                file_map[map_name] = filepath

        return file_map

    finally:
        if is_string:
            fileobj.close()
