# -*- coding: utf-8 -*-

from datetime import datetime, time

from lxml import etree
from HTMLParser import HTMLParser


NBSP = u'\xa0'
_not_specified = object()


def get_sub_tag_text(tag, tagname, silent=False, default=u"", nsmap=None):
    try:
        return tag.find('./' + tagname, nsmap).text or u""
    except AttributeError:
        if silent:
            return default
        else:
            raise


def get_sub_tag_text2(tag, tagname, default=_not_specified, nsmap=None):
    """
    Упрощенная версия get_sub_tag_text
    Тег может быть пустым, без текста, в этом случае text == None, но функция
    возвращает u'' или default, если указано.
    """

    if_empty_text = u'' if default is _not_specified else default

    subtag = tag.find('./' + tagname, nsmap)
    try:
        return subtag.text or if_empty_text
    except AttributeError:
        if default is _not_specified:
            raise
        else:
            return default


def copy_lxml_element(el, top_element_only=False):
    el_str = etree.tostring(el, encoding='utf8')
    el = etree.fromstring(el_str, parser=etree.XMLParser(huge_tree=True))

    if top_element_only:
        del el[:]

    return el


def lxml_get_text(element):
    return u''.join(element.xpath('.//text()')).strip()


def lxml_get_date(element, format='%Y-%m-%d'):
    try:
        return datetime.strptime(lxml_get_text(element), format).date()
    except ValueError:
        pass


def lxml_get_time(element, format=None):
    text = lxml_get_text(element)
    try:
        if format is None:
            return time(*[int(t.strip()) for t in text.split(':')])
        else:
            return datetime.strptime(lxml_get_text(element), format).time()
    except ValueError:
        pass


def lxml_to_unicode(element):
    return etree.tounicode(element, pretty_print=True)


def lxml_humanize(element, **kwargs):
    data = etree.tounicode(element, pretty_print=True, **kwargs)
    return HTMLParser().unescape(data)
