# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os
from collections import OrderedDict

from django.conf import settings

from common.db.mds.clients import mds_s3_common_client
from common.settings.utils import define_setting
from travel.rasp.admin.lib.jinja import render_to_response


define_setting('MDS_TMP_LISTING_CLIENT', default=mds_s3_common_client)


def files_listing(prefix, mds_client):
    files = []
    for obj in mds_client.get_prefix_keys(prefix):
        key = obj['Key']
        files.append({
            'key': key[len(prefix):].lstrip('/'),
            'last_modified': obj['LastModified'].replace(microsecond=0).isoformat(),
            'size': obj['Size']
        })

    return files


def get_file_attrs(path, last_modified='-', size='-'):
    return {
        'ref': path,
        'last_modified': last_modified,
        'size': size
    }


def get_listing_context(request_path, mds_client):
    prefix = request_path.split('mds_files_viewer/')[-1]
    files = files_listing(prefix=prefix, mds_client=mds_client)
    files_attrs = {}
    for f in files:
        path = f['key'].split('/')[0]
        if path == f['key']:
            ref = '{}/{}/{}'.format(mds_client.url, mds_client.bucket, prefix)
            files_attrs[path] = get_file_attrs(os.path.join(ref, path), f['last_modified'], f['size'])
        else:
            files_attrs[path] = get_file_attrs(os.path.join(request_path, path))

    if len(prefix.split('/')) > 1:
        files_attrs['. . /'] = get_file_attrs('/'.join(request_path.split('/')[:-1]))

    return {
        'list':  OrderedDict(sorted(files_attrs.items(), key=lambda t: t[0])),
        'current_level': request_path
    }


def listing(request):
    context = get_listing_context(request.path, settings.MDS_TMP_LISTING_CLIENT)
    return render_to_response('mds_files_viewer/listing.html', context, request=request)
