# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os
import traceback

import yatest

from library.python.testing.recipe import declare_recipe
from travel.library.recipe_utils.utils import log


def start(argv):
    log('Setting up migration')

    process_env = os.environ.copy()
    process_env.update({
        'Y_PYTHON_ENTRY_POINT': 'travel.rasp.admin.app:manage',
        'DJANGO_SETTINGS_MODULE': 'common.tester.settings',
        'RASP_VAULT_STUB_SECRETS': '1',
        'RASP_GEOBASE_DATA_PATH': '{}/geodata/geodata4-tree+ling.bin'.format(os.getcwd()),
        'actual_db': os.getenv('TRAVEL_MYSQL_RECIPE_TESTS_DB', 'rasp_tests')
    })

    try:
        yatest.common.execute(
            [
                yatest.common.build_path('travel/rasp/admin/bin/app/app'),
                'migrate'
            ],
            env=process_env
        )
    except Exception as ex:
        log('Exception', repr(ex), traceback.format_exc())
        raise ex

    log('Done migration')


def stop(argv):
    pass


def main():
    declare_recipe(start, stop)
