# -*- coding: utf-8 -*-
# Generated by Django 1.9.12 on 2017-08-16 16:14
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations
from django.db.models import Max


def move_new_bindings_to_old(apps, schema_editor):
    if settings.IS_BLANK_TEST_DB:
        return

    CoachInfo = apps.get_model('order', 'CoachInfo')
    CoachInfoBinding = apps.get_model('order', 'CoachInfoBinding')
    for info in CoachInfo.objects.all():
        bindings = CoachInfoBinding.objects.filter(info=info)
        if bindings:
            binding = bindings.aggregate(priority=Max('priority'), two_storey=Max('two_storey'))
        else:
            binding = {'priority': 10, 'two_storey': False}
        if info.ufs_code:
            CoachInfoBinding.objects.create(coach_subtype_code=info.ufs_code,
                                            priority=max(binding['priority'] + 1, 20),
                                            info=info,
                                            )
        info.two_storey = binding['two_storey']
        info.save()


class Migration(migrations.Migration):

    dependencies = [
        ('order', '0012_coach_info_binding_change'),
    ]

    operations = [
        migrations.RunPython(move_new_bindings_to_old, reverse_code=migrations.RunPython.noop),
    ]
