# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import re

from django.utils import six
from django.utils.encoding import force_text
from django.utils.functional import Promise


non_russian_letters = re.compile('[^а-яёА-ЯЁ]*', re.U)


def patch_migration_writer():
    """
    Патчим миграции джанги, чтобы в миграциях оставался русский текст
    """
    from django.db.migrations.writer import MigrationWriter

    old_serialize = MigrationWriter.serialize

    def new_serialize(cls, value):
        if isinstance(value, Promise):
            value = force_text(value)

        if isinstance(value, six.text_type):
            if six.PY3:
                value_repr = repr(value)
            else:
                def encode_unicode_escape(match):
                    return match.group(0).encode('unicode_escape')

                value_repr = "'{}'".format(non_russian_letters.sub(encode_unicode_escape, value))

            return value_repr, set()
        else:
            return old_serialize(value)

    MigrationWriter.serialize = classmethod(new_serialize)
