# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='PromoPage',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('slogan', models.CharField(max_length=255, verbose_name='\u0421\u043b\u043e\u0433\u0430\u043d')),
                ('description', models.CharField(help_text='\u041c\u0435\u0442\u0430-\u0442\u0435\u0433 \xabdescription\xbb (\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b)', max_length=255, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b')),
                ('metric_id', models.CharField(max_length=100, null=True, verbose_name='id \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430 \u043c\u0435\u0442\u0440\u0438\u043a\u0438', blank=True)),
                ('active', models.BooleanField(verbose_name='\u0430\u043a\u0442\u0438\u0432\u043d\u0430\u044f')),
            ],
            options={
                'ordering': ('title',),
                'verbose_name': '\u043f\u0440\u043e\u043c\u043e-\u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430',
                'verbose_name_plural': '\u043f\u0440\u043e\u043c\u043e-\u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b',
            },
        ),
        migrations.CreateModel(
            name='PromoSettlement',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('direction', models.IntegerField(verbose_name='\u043e\u0442\u043a\u0443\u0434\u0430/\u043a\u0443\u0434\u0430', choices=[(1, '\u043e\u0442\u043a\u0443\u0434\u0430'), (2, '\u043a\u0443\u0434\u0430')])),
                ('priority', models.IntegerField(verbose_name='\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442')),
                ('promo_page', models.ForeignKey(verbose_name='\u041f\u0440\u043e\u043c\u043e-\u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430', to='promosearch.PromoPage')),
                ('settlement', models.ForeignKey(verbose_name='\u0413\u043e\u0440\u043e\u0434', to='www.Settlement')),
            ],
            options={
                'ordering': ('promo_page', 'priority', 'settlement'),
                'verbose_name': '\u043f\u0440\u043e\u043c\u043e-\u0433\u043e\u0440\u043e\u0434',
                'verbose_name_plural': '\u043f\u0440\u043e\u043c\u043e-\u0433\u043e\u0440\u043e\u0434\u0430',
            },
        ),
        migrations.CreateModel(
            name='ScheduleTable',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('value', models.CharField(max_length=255, verbose_name='\u0422\u0435\u043a\u0441\u0442')),
                ('company', models.ForeignKey(verbose_name='\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a', to='www.Company')),
                ('promo_page', models.ForeignKey(verbose_name='\u041f\u0440\u043e\u043c\u043e-\u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430', to='promosearch.PromoPage')),
                ('station_from', models.ForeignKey(related_name='promosearch_scheduletable_from', verbose_name='\u041e\u0442\u043a\u0443\u0434\u0430', to='www.Station')),
                ('station_to', models.ForeignKey(related_name='promosearch_scheduletable_to', verbose_name='\u041a\u0443\u0434\u0430', to='www.Station')),
                ('t_type', models.ForeignKey(default=3, verbose_name='\u0422\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType')),
            ],
            options={
                'ordering': ('promo_page', 'company', 'station_from'),
                'verbose_name': '\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f "\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a+\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435" -> "\u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435"',
            },
        ),
        migrations.CreateModel(
            name='TariffCache',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('route_number', models.CharField(default=b'', max_length=100, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441')),
                ('value_min', models.FloatField(verbose_name='\u0426\u0435\u043d\u0430 min')),
                ('value_max', models.FloatField(verbose_name='\u0426\u0435\u043d\u0430 max')),
                ('station_from', models.ForeignKey(related_name='promosearch_tariffcache_from', verbose_name='\u041e\u0442\u043a\u0443\u0434\u0430', to='www.Station')),
                ('station_to', models.ForeignKey(related_name='promosearch_tariffcache_to', verbose_name='\u041a\u0443\u0434\u0430', to='www.Station')),
            ],
        ),
        migrations.CreateModel(
            name='TariffTable',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('value', models.CharField(max_length=255, verbose_name='\u0426\u0435\u043d\u0430')),
                ('company', models.ForeignKey(verbose_name='\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a', to='www.Company')),
                ('promo_page', models.ForeignKey(verbose_name='\u041f\u0440\u043e\u043c\u043e-\u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430', to='promosearch.PromoPage')),
                ('station_from', models.ForeignKey(related_name='promosearch_tarifftable_from', verbose_name='\u041e\u0442\u043a\u0443\u0434\u0430', to='www.Station')),
                ('station_to', models.ForeignKey(related_name='promosearch_tarifftable_to', verbose_name='\u041a\u0443\u0434\u0430', to='www.Station')),
                ('t_type', models.ForeignKey(default=1, verbose_name='\u0422\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType')),
            ],
            options={
                'ordering': ('promo_page', 'company', 'station_from'),
                'verbose_name': '\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f "\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a+\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435" -> "\u0446\u0435\u043d\u0430"',
            },
        ),
    ]
