#! -*- coding: utf-8 -*-

import travel.rasp.admin.scripts.load_project  # noqa

import logging

from common.models.geo import Station
from travel.rasp.admin.lib.logs import print_log_to_stdout, create_current_file_run_log, get_script_log_context, ylog_context


log = logging.getLogger(__name__)


if __name__ == '__main__':
    with ylog_context(**get_script_log_context()):
        from optparse import OptionParser

        parser = OptionParser()

        parser = OptionParser()
        parser.add_option("-v", "--verbose", dest="verbose", action="store_true")

        (options, args) = parser.parse_args()

        if options.verbose:
            print_log_to_stdout()

        create_current_file_run_log()

        Station.autotranslate(Station.objects.filter(t_type__code='plane'))
